/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.inventory;

import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.inventory.ContainerBCTile;
import com.brandon3055.brandonscore.inventory.SlotCheckValid;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.blocks.DraconiumChest;
import com.brandon3055.draconicevolution.blocks.tileentity.TileDraconiumChest;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.inventory.InventoryCraftingChest;
import com.brandon3055.draconicevolution.inventory.InventoryCraftingChestResult;
import com.brandon3055.draconicevolution.items.ItemCore;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerDraconiumChest
extends ContainerBCTile<TileDraconiumChest> {
    public InventoryCraftingChest craftMatrix;
    public InventoryCraftingChestResult craftResult;
    private List<Slot> mainInventorySlots = new ArrayList<Slot>();

    public ContainerDraconiumChest(int windowId, PlayerInventory playerInv, PacketBuffer extraData) {
        this(DEContent.container_draconium_chest, windowId, playerInv, (TileDraconiumChest)ContainerDraconiumChest.getClientTile((PacketBuffer)extraData));
    }

    public ContainerDraconiumChest(@Nullable ContainerType<?> type, int windowId, PlayerInventory playerInv, TileDraconiumChest tile) {
        super(type, windowId, playerInv, (TileBCore)tile);
        int x;
        int y;
        tile.onPlayerOpenContainer(playerInv.field_70458_d);
        int slotIndex = 0;
        for (y = 0; y < 10; ++y) {
            for (x = 0; x < 26; ++x) {
                SlotCheckValid slot = new SlotCheckValid((IItemHandler)tile.itemHandler, slotIndex++, 17 + x * 18, 15 + y * 18);
                this.mainInventorySlots.add((Slot)slot);
                this.func_75146_a((Slot)slot);
            }
        }
        for (int x2 = 0; x2 < 5; ++x2) {
            this.func_75146_a((Slot)new SlotSmeltable((IItemHandler)tile.itemHandler, slotIndex++, 51 + x2 * 18, 207));
        }
        this.func_75146_a((Slot)new SlotRFCapacitor((IItemHandler)tile.itemHandler, slotIndex++, 17, 265));
        this.func_75146_a((Slot)new SlotCore((IItemHandler)tile.itemHandler, slotIndex, 23, 207));
        this.craftMatrix = new InventoryCraftingChest((Container)this, 3, 3, tile);
        this.craftResult = new InventoryCraftingChestResult(tile);
        this.func_75146_a((Slot)new CraftingResultSlot(playerInv.field_70458_d, (CraftingInventory)this.craftMatrix, (IInventory)this.craftResult, 0, 434, 225));
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 3; ++x) {
                this.func_75146_a((Slot)new SlotCheckValid.IInv((IInventory)this.craftMatrix, x + y * 3, 340 + x * 18, 207 + y * 18));
            }
        }
        this.addPlayerSlots(170, 207, 3);
    }

    public void func_75130_a(@Nonnull IInventory inventory) {
        if (!Objects.requireNonNull(((TileDraconiumChest)this.tile).func_145831_w()).func_201670_d()) {
            ItemStack stack = ItemStack.field_190927_a;
            Optional optional = Objects.requireNonNull(((TileDraconiumChest)this.tile).func_145831_w().func_73046_m()).func_199529_aN().func_215371_a(IRecipeType.field_222149_a, (IInventory)this.craftMatrix, ((TileDraconiumChest)this.tile).func_145831_w());
            if (optional.isPresent()) {
                ICraftingRecipe recipe = (ICraftingRecipe)optional.get();
                if (this.craftResult.func_201561_a(((TileDraconiumChest)this.tile).func_145831_w(), (ServerPlayerEntity)this.player, (IRecipe)recipe)) {
                    stack = recipe.func_77572_b((IInventory)this.craftMatrix);
                }
            }
            this.craftResult.func_70299_a(1, stack);
            super.func_75130_a(inventory);
            ((ServerPlayerEntity)this.player).field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(this.field_75152_c, 267, stack));
        }
    }

    @Nullable
    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < 260) {
                if (!this.func_75135_a(itemstack1, 277, this.field_75151_b.size(), false)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index == 267 || index == 265 || index == 266) {
                if (!this.func_75135_a(itemstack1, 277, this.field_75151_b.size(), false) && !this.func_75135_a(itemstack1, 0, 259, false)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index >= 260 && index < 277) {
                if (!this.func_75135_a(itemstack1, 0, 259, false) && !this.func_75135_a(itemstack1, 277, this.field_75151_b.size(), false)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (!DraconiumChest.isStackValid(itemstack1) || !this.func_75135_a(itemstack1, 0, 259, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            slot.func_190901_a(this.player, itemstack1);
        }
        return itemstack;
    }

    @Nullable
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        ItemStack stack = super.func_184996_a(slotId, dragType, clickTypeIn, player);
        if (dragType == 1 && clickTypeIn == ClickType.PICKUP && slotId >= 260 && slotId <= 264) {
            ((TileDraconiumChest)this.tile).validateSmelting();
        }
        return stack;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        ((TileDraconiumChest)this.tile).onPlayerCloseContainer(playerIn);
    }

    public class SlotCore
    extends SlotItemHandler {
        public SlotCore(IItemHandler inventory, int id, int x, int y) {
            super(inventory, id, x, y);
        }

        public boolean func_75214_a(ItemStack stack) {
            if (super.func_75214_a(stack)) {
                return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemCore;
            }
            return false;
        }

        public int func_75219_a() {
            return 1;
        }
    }

    public class SlotRFCapacitor
    extends SlotItemHandler {
        public SlotRFCapacitor(IItemHandler inventory, int id, int x, int y) {
            super(inventory, id, x, y);
        }

        public boolean func_75214_a(ItemStack stack) {
            if (super.func_75214_a(stack)) {
                return EnergyUtils.canExtractEnergy((ItemStack)stack);
            }
            return false;
        }

        public int func_75219_a() {
            return 1;
        }
    }

    public class SlotSmeltable
    extends SlotItemHandler {
        public SlotSmeltable(IItemHandler p_i1824_1_, int p_i1824_2_, int p_i1824_3_, int p_i1824_4_) {
            super(p_i1824_1_, p_i1824_2_, p_i1824_3_, p_i1824_4_);
        }

        public boolean func_75214_a(ItemStack stack) {
            return ((TileDraconiumChest)ContainerDraconiumChest.this.tile).getSmeltResult(stack) != null;
        }
    }
}

