/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.lib.TechPropBuilder;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.IReaperItem;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.ProjectileData;
import com.brandon3055.draconicevolution.api.modules.data.SpeedData;
import com.brandon3055.draconicevolution.api.modules.entities.AutoFireEntity;
import com.brandon3055.draconicevolution.api.modules.lib.ModularOPStorage;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostImpl;
import com.brandon3055.draconicevolution.entity.projectile.DraconicArrowEntity;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.init.ModuleCfg;
import com.brandon3055.draconicevolution.items.equipment.IModularItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.SpectralArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class ModularBow
extends BowItem
implements IReaperItem,
IModularItem {
    private final TechLevel techLevel;

    public ModularBow(TechPropBuilder props) {
        super(props.build().func_234689_a_());
        this.techLevel = props.techLevel;
    }

    @Override
    public TechLevel getTechLevel() {
        return this.techLevel;
    }

    @Override
    public ModuleHostImpl createHost(ItemStack stack) {
        ModuleHostImpl host = new ModuleHostImpl(this.techLevel, ModuleCfg.toolWidth(this.techLevel), ModuleCfg.toolHeight(this.techLevel), "bow", ModuleCfg.removeInvalidModules, new ModuleCategory[0]);
        host.addCategories(ModuleCategory.RANGED_WEAPON);
        return host;
    }

    @Override
    @Nullable
    public ModularOPStorage createOPStorage(ItemStack stack, ModuleHostImpl host) {
        return new ModularOPStorage(host, EquipCfg.getBaseToolEnergy(this.techLevel), EquipCfg.getBaseToolTransfer(this.techLevel));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        this.addModularItemInformation(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public int getReaperLevel(ItemStack stack) {
        return 0;
    }

    public void func_219972_a(World world, LivingEntity player, ItemStack stack, int count) {
        AutoFireEntity entity;
        if (this.func_77626_a(stack) - count >= ModularBow.getChargeTicks(stack) && (entity = (AutoFireEntity)((ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElseThrow(IllegalStateException::new)).getEntitiesByType(ModuleTypes.AUTO_FIRE).map(e -> (AutoFireEntity)e).findAny().orElse(null)) != null && entity.getAutoFireEnabled()) {
            Hand usingHand = player.func_184600_cs();
            player.func_184602_cy();
            stack.func_77974_b(world, player, 0);
            player.func_184598_c(usingHand);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack;
        boolean hasAmmo = !player.func_213356_f(stack = player.func_184586_b(hand)).func_190926_b() || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)stack, (World)world, (PlayerEntity)player, (Hand)hand, (boolean)hasAmmo);
        if (ret != null) {
            return ret;
        }
        if (EnergyUtils.getEnergyStored((ItemStack)stack) < ModularBow.calculateShotEnergy(stack)) {
            hasAmmo = false;
        }
        if (!player.field_71075_bZ.field_75098_d && !hasAmmo) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        player.func_184598_c(hand);
        return ActionResult.func_226249_b_((Object)stack);
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity entity, int timeLeft) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            boolean noAmmoRequired = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            ItemStack ammoStack = player.func_213356_f(stack);
            int drawTime = this.func_77626_a(stack) - timeLeft;
            if ((drawTime = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)world, (PlayerEntity)player, (int)drawTime, (!ammoStack.func_190926_b() || noAmmoRequired ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!ammoStack.func_190926_b() || noAmmoRequired) {
                if (ammoStack.func_190926_b()) {
                    ammoStack = new ItemStack((IItemProvider)Items.field_151032_g);
                }
                ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElseThrow(IllegalStateException::new);
                ProjectileData projData = host.getModuleData(ModuleTypes.PROJ_MODIFIER, new ProjectileData(0.0f, 0.0f, 0.0f, 0.0f, 0.0f));
                float powerForTime = ModularBow.getPowerForTime(drawTime, stack) * (projData.getVelocity() + 1.0f);
                if ((double)powerForTime >= 0.1) {
                    boolean infiniteAmmo;
                    boolean bl = infiniteAmmo = player.field_71075_bZ.field_75098_d || ammoStack.func_77973_b() instanceof ArrowItem && ((ArrowItem)ammoStack.func_77973_b()).isInfinite(ammoStack, stack, player);
                    if (!world.field_72995_K) {
                        long energyRequired;
                        ArrowItem arrowitem = (ArrowItem)(ammoStack.func_77973_b() instanceof ArrowItem ? ammoStack.func_77973_b() : Items.field_151032_g);
                        DraconicArrowEntity arrowEntity = this.customArrow(arrowitem.func_200887_a(world, ammoStack, (LivingEntity)player));
                        arrowEntity.setEffectsFromItem(ammoStack);
                        arrowEntity.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, powerForTime * 3.0f, 1.0f - projData.getAccuracy());
                        arrowEntity.setTechLevel(this.techLevel);
                        arrowEntity.setPenetration(projData.getPenetration());
                        arrowEntity.setGravComp(projData.getAntiGrav());
                        if (host.getEntitiesByType(ModuleTypes.PROJ_ANTI_IMMUNE).findAny().isPresent()) {
                            arrowEntity.setProjectileImmuneOverride(true);
                        }
                        if (powerForTime == 1.0f) {
                            arrowEntity.func_70243_d(true);
                        }
                        arrowEntity.func_70239_b(arrowEntity.func_70242_d() * (double)(projData.getDamage() + 1.0f));
                        int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
                        if (j > 0) {
                            arrowEntity.func_70239_b(arrowEntity.func_70242_d() + (double)j * 0.5 + 0.5);
                        }
                        if (this.extractEnergy(player, stack, energyRequired = (long)((double)EquipCfg.bowBaseEnergy * arrowEntity.func_70242_d() * (double)powerForTime * 3.0)) < energyRequired) {
                            return;
                        }
                        int k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack);
                        if (k > 0) {
                            arrowEntity.func_70240_a(k);
                        }
                        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                            arrowEntity.func_70015_d(100);
                        }
                        if (infiniteAmmo) {
                            arrowEntity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                        }
                        world.func_217376_c((Entity)arrowEntity);
                    }
                    world.func_184148_a((PlayerEntity)null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + powerForTime * 0.5f);
                    if (!infiniteAmmo && !player.field_71075_bZ.field_75098_d) {
                        ammoStack.func_190918_g(1);
                        if (ammoStack.func_190926_b()) {
                            player.field_71071_by.func_184437_d(ammoStack);
                        }
                    }
                    player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                }
            }
        }
    }

    public DraconicArrowEntity customArrow(AbstractArrowEntity arrow) {
        Entity owner = arrow.func_234616_v_();
        if (!(owner instanceof LivingEntity)) {
            return new DraconicArrowEntity(DEContent.draconicArrow, arrow.field_70170_p);
        }
        DraconicArrowEntity newArrow = new DraconicArrowEntity(arrow.field_70170_p, (LivingEntity)arrow.func_234616_v_());
        if (arrow instanceof SpectralArrowEntity) {
            newArrow.setSpectral(((SpectralArrowEntity)arrow).field_184562_f);
        }
        return newArrow;
    }

    public static float calculateDamage(ItemStack stack) {
        ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElseThrow(IllegalStateException::new);
        ProjectileData projData = host.getModuleData(ModuleTypes.PROJ_MODIFIER, new ProjectileData(0.0f, 0.0f, 0.0f, 0.0f, 0.0f));
        float baseDamage = 2.0f;
        baseDamage *= 1.0f + projData.getDamage();
        baseDamage *= 3.0f * (1.0f + projData.getVelocity());
        int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
        if (j > 0) {
            baseDamage = (float)((double)baseDamage + ((double)j * 0.5 + 0.5));
        }
        return baseDamage;
    }

    public static long calculateShotEnergy(ItemStack stack) {
        float damage = ModularBow.calculateDamage(stack);
        return (long)(damage * (float)EquipCfg.bowBaseEnergy);
    }

    public static float getPowerForTime(int time, ItemStack stack) {
        float fullChargeTime = ModularBow.getChargeTicks(stack);
        float power = (float)time / fullChargeTime;
        if ((power = (power * power + power * 2.0f) / 3.0f) > 1.0f) {
            power = 1.0f;
        }
        return power;
    }

    public static int getChargeTicks(ItemStack stack) {
        ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElseThrow(IllegalStateException::new);
        SpeedData data = host.getModuleData(ModuleTypes.SPEED);
        float speedModifier = data == null ? 0.0f : (float)data.getSpeedMultiplier();
        return (int)Math.ceil(20.0f / (speedModifier += 1.0f));
    }

    @Override
    public void addModularItemInformation(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        IModularItem.super.addModularItemInformation(stack, worldIn, tooltip, flagIn);
        if (worldIn != null && stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).isPresent()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.draconicevolution.bow.damage", new Object[]{Float.valueOf((float)Math.round(ModularBow.calculateDamage(stack) * 10.0f) / 10.0f)}).func_240699_a_(TextFormatting.DARK_GREEN));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.draconicevolution.bow.energy_per_shot", new Object[]{Utils.addCommas((long)ModularBow.calculateShotEnergy(stack))}).func_240699_a_(TextFormatting.DARK_GREEN));
        }
    }
}

