/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.lib.TechPropBuilder;
import com.brandon3055.draconicevolution.api.IReaperItem;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.damage.IDraconicDamage;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.DamageModData;
import com.brandon3055.draconicevolution.api.modules.lib.ModularOPStorage;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostImpl;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.init.ModuleCfg;
import com.brandon3055.draconicevolution.items.equipment.DEItemTier;
import com.brandon3055.draconicevolution.items.equipment.IModularMelee;
import com.brandon3055.draconicevolution.items.equipment.IModularMiningTool;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModularStaff
extends ToolItem
implements IReaperItem,
IModularMiningTool,
IModularMelee,
IDraconicDamage {
    private final TechLevel techLevel;
    private final DEItemTier itemTier;

    public ModularStaff(TechPropBuilder props) {
        super(0.0f, 0.0f, (IItemTier)new DEItemTier(props, EquipCfg::getStaffDmgMult, EquipCfg::getStaffSpeedMult, EquipCfg::getStaffEffMult), Collections.EMPTY_SET, props.staffProps());
        this.techLevel = props.techLevel;
        this.itemTier = (DEItemTier)this.func_200891_e();
    }

    @Override
    public TechLevel getTechLevel() {
        return this.techLevel;
    }

    @Override
    public DEItemTier getItemTier() {
        return this.itemTier;
    }

    @Override
    public TechLevel getTechLevel(@Nullable ItemStack stack) {
        return this.techLevel;
    }

    @Override
    public ModuleHostImpl createHost(ItemStack stack) {
        ModuleHostImpl host = new ModuleHostImpl(this.techLevel, ModuleCfg.staffWidth(this.techLevel), ModuleCfg.staffHeight(this.techLevel), "staff", ModuleCfg.removeInvalidModules, new ModuleCategory[0]);
        host.addCategories(ModuleCategory.RANGED_WEAPON);
        return host;
    }

    @Override
    @Nullable
    public ModularOPStorage createOPStorage(ItemStack stack, ModuleHostImpl host) {
        return new ModularOPStorage(host, EquipCfg.getBaseStaffEnergy(this.techLevel), EquipCfg.getBaseStaffTransfer(this.techLevel));
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        return IModularMiningTool.super.getDestroySpeed(stack, state);
    }

    public boolean func_150897_b(BlockState blockIn) {
        return true;
    }

    @Override
    public float getBaseEfficiency() {
        return this.func_200891_e().func_200928_b();
    }

    @Override
    public boolean overrideEffectivity(Material material) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        this.addModularItemInformation(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public int getReaperLevel(ItemStack stack) {
        return this.techLevel.index + 1;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y == EnchantmentType.DIGGER || enchantment.field_77351_y == EnchantmentType.WEAPON || super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public static float getRenderChargeState(float chargeTime) {
        if (chargeTime >= 40.0f) {
            return Math.min(1.0f, 0.5f + (chargeTime - 40.0f) / 5.0f);
        }
        if (chargeTime >= 20.0f) {
            return Math.min(0.5f, (chargeTime - 20.0f) / 5.0f);
        }
        return 0.0f;
    }

    public static float getDrawPower(float drawProgress) {
        drawProgress = (drawProgress * drawProgress + drawProgress * 2.0f) / 3.0f;
        return Math.min(drawProgress, 1.0f);
    }

    private boolean canFire(ItemStack stack, PlayerEntity player) {
        return true;
    }

    @Nullable
    public static Module<DamageModData> getDamageModule(ItemStack stack) {
        ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElseThrow(IllegalStateException::new);
        ModuleEntity entity = host.getEntitiesByType(ModuleTypes.DAMAGE_MOD).findAny().orElse(null);
        return entity != null && entity.getModule().getData() instanceof DamageModData ? entity.getModule() : null;
    }
}

