/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.tools;

import com.brandon3055.brandonscore.api.hud.IHudItem;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.utils.TargetPos;
import com.brandon3055.draconicevolution.entity.PersistentItemEntity;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.tools.DislocatorAdvanced;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.AnvilUpdateEvent;

public class Dislocator
extends Item
implements IHudItem {
    public Dislocator(Item.Properties properties) {
        super(properties.func_234689_a_());
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public Entity dislocateEntity(ItemStack stack, @Nonnull Entity user, @Nonnull Entity target, TargetPos targetPos) {
        if (target.field_70170_p.field_72995_K) {
            return target;
        }
        if (targetPos == null) {
            this.messageUser(user, (ITextComponent)new TranslationTextComponent("dislocate.draconicevolution.not_set").func_240699_a_(TextFormatting.RED));
            return target;
        }
        BCoreNetwork.sendSound((World)target.field_70170_p, (BlockPos)target.func_233580_cy_(), (SoundEvent)DESounds.portal, (SoundCategory)SoundCategory.PLAYERS, (float)0.1f, (float)(target.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f), (boolean)false);
        target = targetPos.teleport(target);
        BCoreNetwork.sendSound((World)target.field_70170_p, (BlockPos)target.func_233580_cy_(), (SoundEvent)DESounds.portal, (SoundCategory)SoundCategory.PLAYERS, (float)0.1f, (float)(target.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f), (boolean)false);
        return target;
    }

    public void messageUser(Entity user, ITextComponent message) {
        if (user instanceof PlayerEntity) {
            ((PlayerEntity)user).func_146105_b(message, true);
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        if (entity instanceof PlayerEntity && !(this instanceof DislocatorAdvanced)) {
            this.messageUser((Entity)player, (ITextComponent)new TranslationTextComponent("dislocate.draconicevolution.player_need_advanced").func_240699_a_(TextFormatting.RED));
            return true;
        }
        if (player.field_70170_p.field_72995_K || !entity.func_184222_aU() || !(entity instanceof LivingEntity) || player.func_184811_cZ().func_185143_a((Item)this, 0.0f) > 0.0f) {
            return true;
        }
        if (player.func_110143_aJ() > 2.0f || player.field_71075_bZ.field_75098_d) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_70606_j(player.func_110143_aJ() - 2.0f);
            }
            TargetPos location = this.getTargetPos(stack, player.field_70170_p);
            player.func_184811_cZ().func_185145_a((Item)this, 20);
            this.dislocateEntity(stack, (Entity)player, entity, location);
            stack.func_222118_a(1, (LivingEntity)player, e -> {});
            if (location != null) {
                this.messageUser((Entity)player, (ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"dislocate.draconicevolution.entity_sent_to", (Object[])new Object[0]) + " " + location.getReadableName(false)).func_240699_a_(TextFormatting.GREEN));
            }
        } else if (player.field_70170_p.field_72995_K) {
            this.messageUser((Entity)player, (ITextComponent)new TranslationTextComponent("dislocate.draconicevolution.low_health").func_240699_a_(TextFormatting.RED));
        }
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        TargetPos targetPos = this.getTargetPos(stack, world);
        if (player.func_225608_bj_()) {
            if (targetPos == null) {
                targetPos = new TargetPos((Entity)player);
                this.setLocation(stack, targetPos);
                this.messageUser((Entity)player, (ITextComponent)new TranslationTextComponent("dislocate.draconicevolution.bound_to").func_240702_b_("{" + targetPos.getReadableName(false) + "}").func_240699_a_(TextFormatting.GREEN));
            } else {
                this.messageUser((Entity)player, (ITextComponent)new TranslationTextComponent("dislocate.draconicevolution.already_bound").func_240699_a_(TextFormatting.RED));
            }
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        if (targetPos == null) {
            this.messageUser((Entity)player, (ITextComponent)new TranslationTextComponent("dislocate.draconicevolution.not_set").func_240699_a_(TextFormatting.RED));
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        if (player.func_110143_aJ() > 2.0f || player.field_71075_bZ.field_75098_d) {
            player.func_184811_cZ().func_185145_a((Item)this, 20);
            this.dislocateEntity(stack, (Entity)player, (Entity)player, targetPos);
            stack.func_222118_a(1, (LivingEntity)player, e -> {});
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_70606_j(player.func_110143_aJ() - 2.0f);
            }
        } else {
            this.messageUser((Entity)player, (ITextComponent)new TranslationTextComponent("dislocate.draconicevolution.low_health").func_240699_a_(TextFormatting.RED));
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.getTargetPos(stack, null) != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TargetPos targetPos = this.getTargetPos(stack, world);
        if (targetPos == null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("dislocate.draconicevolution.un_set_info1").func_240699_a_(TextFormatting.RED));
            tooltip.add((ITextComponent)new TranslationTextComponent("dislocate.draconicevolution.un_set_info2").func_240699_a_(TextFormatting.WHITE));
            tooltip.add((ITextComponent)new TranslationTextComponent("dislocate.draconicevolution.un_set_info3").func_240699_a_(TextFormatting.WHITE));
            tooltip.add((ITextComponent)new TranslationTextComponent("dislocate.draconicevolution.un_set_info4").func_240699_a_(TextFormatting.WHITE));
            tooltip.add((ITextComponent)new TranslationTextComponent("dislocate.draconicevolution.un_set_info5").func_240699_a_(TextFormatting.WHITE));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("dislocate.draconicevolution.bound_to").func_240699_a_(TextFormatting.GREEN));
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "{" + targetPos.getReadableName(flagIn.func_194127_a()) + "}"));
            tooltip.add((ITextComponent)new TranslationTextComponent("dislocate.draconicevolution.uses_remain", new Object[]{stack.func_77958_k() - stack.func_77952_i() + 1}).func_240699_a_(TextFormatting.BLUE));
        }
    }

    public TargetPos getTargetPos(ItemStack stack, @Nullable World world) {
        CompoundNBT targetTag = stack.func_179543_a("target");
        if (targetTag != null) {
            return new TargetPos(targetTag);
        }
        return null;
    }

    public void setLocation(ItemStack stack, TargetPos pos) {
        stack.func_77983_a("target", (INBT)pos.writeToNBT());
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Nullable
    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new PersistentItemEntity(world, location, itemstack);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() == DEContent.ingot_draconium;
    }

    public float getXpRepairRatio(ItemStack stack) {
        return 1.0f;
    }

    public void generateHudText(ItemStack stack, PlayerEntity player, List<ITextComponent> displayList) {
        TargetPos location = this.getTargetPos(stack, player.field_70170_p);
        if (location != null) {
            displayList.add(stack.func_200301_q());
            displayList.add((ITextComponent)new StringTextComponent("{" + location.getReadableName(false) + ")"));
        }
    }

    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        if (event.getLeft().func_77973_b() == DEContent.dislocator && event.getRight().func_77973_b() == DEContent.ingot_draconium && event.getLeft().func_77952_i() > 0) {
            event.setOutput(event.getLeft().func_77946_l());
            event.getOutput().func_196085_b(0);
            event.setCost(1);
            event.setMaterialCost(1);
        }
    }
}

