/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.tools;

import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.brandonscore.utils.TargetPos;
import com.brandon3055.draconicevolution.api.ITeleportEndPoint;
import com.brandon3055.draconicevolution.entity.PersistentItemEntity;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.handlers.DislocatorLinkHandler;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.tools.Dislocator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DislocatorBound
extends Dislocator {
    private ModelResourceLocation modelLocation = new ModelResourceLocation("draconicevolution:dislocator_bound");

    public DislocatorBound(Item.Properties properties) {
        super(properties);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity.field_70173_aa % 20 == 0 && !world.field_72995_K && this.isValid(stack) && !this.isPlayer(stack) && entity instanceof PlayerEntity) {
            DislocatorLinkHandler.updateLink(world, stack, (PlayerEntity)entity);
        }
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (entity.field_70292_b % 20 == 0 && !entity.field_70170_p.field_72995_K && this.isValid(stack) && !this.isPlayer(stack)) {
            DislocatorLinkHandler.updateLink(entity.field_70170_p, stack, entity.func_233580_cy_(), (RegistryKey<World>)entity.field_70170_p.func_234923_W_());
        }
        return false;
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        TargetPos location = this.getTargetPos(stack, player.field_70170_p);
        if (location == null) {
            if (this.isPlayer(stack)) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("info.de.bound_dislocator.cant_find_player").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("info.de.bound_dislocator.cant_find_target").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            }
            return true;
        }
        if (!entity.func_184222_aU() || !(entity instanceof LivingEntity)) {
            return true;
        }
        BCoreNetwork.sendSound((World)player.field_70170_p, (BlockPos)player.func_233580_cy_(), (SoundEvent)DESounds.portal, (SoundCategory)SoundCategory.PLAYERS, (float)0.1f, (float)(player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f), (boolean)false);
        location.setPitch(player.field_70125_A);
        location.setYaw(player.field_70177_z);
        this.notifyArriving(stack, player.field_70170_p, entity);
        location.teleport(entity);
        BCoreNetwork.sendSound((World)player.field_70170_p, (BlockPos)player.func_233580_cy_(), (SoundEvent)DESounds.portal, (SoundCategory)SoundCategory.PLAYERS, (float)0.1f, (float)(player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f), (boolean)false);
        return true;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.field_70170_p.field_72995_K) {
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    public boolean isValid(ItemStack stack) {
        CompoundNBT compound = stack.func_77978_p();
        return stack.func_77973_b() == DEContent.dislocator_p2p && compound != null && (compound.func_74764_b("PlayerLink") || compound.func_74764_b("LinkKey") && compound.func_74764_b("Side"));
    }

    public boolean isPlayer(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("PlayerLink");
    }

    public String getLinkID(ItemStack stack) {
        return this.getKey(stack) + "|" + this.getSide(stack);
    }

    public String getPlayerID(ItemStack stack) {
        return ItemNBTHelper.getString((ItemStack)stack, (String)"PlayerLink", (String)"");
    }

    public String getLinkToID(ItemStack stack) {
        return this.getKey(stack) + "|" + (this.getSide(stack) == 0 ? 1 : 0);
    }

    public String getKey(ItemStack stack) {
        return ItemNBTHelper.getString((ItemStack)stack, (String)"LinkKey", (String)"");
    }

    public int getSide(ItemStack stack) {
        return ItemNBTHelper.getByte((ItemStack)stack, (String)"Side", (int)-1);
    }

    @Override
    public TargetPos getTargetPos(ItemStack stack, @Nullable World world) {
        if (world instanceof ServerWorld) {
            DislocatorLinkHandler.LinkData data = DislocatorLinkHandler.getLink(stack, (ServerWorld)world);
            if (this.isPlayer(stack)) {
                MinecraftServer server = world.func_73046_m();
                if (server == null) {
                    return null;
                }
                ServerPlayerEntity player = server.func_184103_al().func_177451_a(UUID.fromString(this.getPlayerID(stack)));
                if (player == null) {
                    return null;
                }
                return new TargetPos(player.func_226277_ct_(), player.func_226278_cu_() + 0.2, player.func_226281_cx_(), player.field_70170_p.func_234923_W_());
            }
            Vec3D pos = DislocatorLinkHandler.getLinkPos(world, stack);
            if (data != null && pos != null) {
                return new TargetPos(pos.x, pos.y, pos.z, data.dimension);
            }
        }
        return null;
    }

    public void notifyArriving(ItemStack stack, World world, Entity entity) {
        DislocatorLinkHandler.LinkData data;
        if (world instanceof ServerWorld && (data = DislocatorLinkHandler.getLink(stack, (ServerWorld)world)) != null && this.isValid(stack) && !this.isPlayer(stack)) {
            if (world.func_73046_m() == null) {
                return;
            }
            TileEntity tile = world.func_73046_m().func_71218_a(data.dimension).func_175625_s(data.pos);
            if (tile instanceof ITeleportEndPoint) {
                ((ITeleportEndPoint)tile).entityArriving(entity);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
    }

    @Override
    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Override
    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new PersistentItemEntity(world, location, itemstack);
    }

    public Rarity func_77613_e(ItemStack stack) {
        return Rarity.RARE;
    }
}

