/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.lib;

import com.brandon3055.brandonscore.handlers.IProcess;
import com.brandon3055.brandonscore.handlers.ProcessHandler;
import com.brandon3055.brandonscore.lib.ShortPos;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import com.brandon3055.draconicevolution.utils.LogHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FallingBlock;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChunkDataPacket;
import net.minecraft.network.play.server.SUpdateLightPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.ServerWorldLightManager;

public class ExplosionHelper {
    private final ServerWorld serverWorld;
    private BlockPos start;
    private ShortPos shortPos;
    private HashSet<Chunk> modifiedChunks = new HashSet();
    private HashSet<Integer> blocksToUpdate = new HashSet();
    private HashSet<Integer> lightUpdates = new HashSet();
    private HashSet<Integer> tilesToRemove = new HashSet();
    private HashMap<ChunkPos, Chunk> chunkCache = new HashMap();
    private static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    public LinkedList<HashSet<Integer>> toRemove = new LinkedList();

    public ExplosionHelper(ServerWorld serverWorld, BlockPos start, ShortPos shortPos) {
        this.serverWorld = serverWorld;
        this.start = start;
        this.shortPos = shortPos;
    }

    public void setBlocksForRemoval(LinkedList<HashSet<Integer>> list) {
        this.toRemove = list;
    }

    public void addBlocksForUpdate(Collection<Integer> blocksToUpdate) {
        this.blocksToUpdate.addAll(blocksToUpdate);
    }

    private void removeBlock(BlockPos pos) {
        Chunk chunk = this.getChunk(pos);
        BlockState oldState = chunk.func_180495_p(pos);
        if (oldState.func_177230_c().hasTileEntity(oldState)) {
            this.serverWorld.func_217377_a(pos, false);
            this.serverWorld.func_225524_e_().func_215568_a(pos);
            return;
        }
        ChunkSection storage = this.getBlockStorage(pos);
        if (storage != null) {
            storage.func_222629_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF, AIR);
        }
        this.setChunkModified(pos);
        this.serverWorld.func_225524_e_().func_215568_a(pos);
    }

    public void setChunkModified(BlockPos blockPos) {
        Chunk chunk = this.getChunk(blockPos);
        this.setChunkModified(chunk);
    }

    public void setChunkModified(Chunk chunk) {
        this.modifiedChunks.add(chunk);
    }

    private Chunk getChunk(BlockPos pos) {
        ChunkPos cp = new ChunkPos(pos);
        if (!this.chunkCache.containsKey(cp)) {
            this.chunkCache.put(cp, this.serverWorld.func_212866_a_(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4));
        }
        return this.chunkCache.get(cp);
    }

    private ChunkSection getBlockStorage(BlockPos pos) {
        Chunk chunk = this.getChunk(pos);
        return chunk.func_76587_i()[pos.func_177956_o() >> 4];
    }

    public void finish() {
        LogHelper.dev("EH: finish");
        RemovalProcess process = new RemovalProcess(this);
        ProcessHandler.addProcess((IProcess)process);
    }

    public boolean isAirBlock(BlockPos pos) {
        return this.serverWorld.func_175623_d(pos);
    }

    public BlockState getBlockState(BlockPos pos) {
        ChunkSection storage = this.getBlockStorage(pos);
        if (storage == null) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return storage.func_177485_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF);
    }

    private static class RemovalProcess
    implements IProcess {
        public boolean isDead = false;
        private ExplosionHelper helper;
        int index = 0;
        private MinecraftServer server;

        public RemovalProcess(ExplosionHelper helper) {
            this.helper = helper;
            this.server = helper.serverWorld.func_73046_m();
        }

        public void updateProcess() {
            this.server.field_211151_aa = Util.func_211177_b();
            while (Util.func_211177_b() - this.server.field_211151_aa < 50L && this.helper.toRemove.size() > 0) {
                LogHelper.dev("Processing chunks at rad: " + this.index);
                HashSet<Integer> set = this.helper.toRemove.removeFirst();
                for (int pos : set) {
                    this.helper.removeBlock(this.helper.shortPos.getActualPos(pos));
                }
                ++this.index;
            }
            this.finishChunks();
            if (this.helper.toRemove.isEmpty()) {
                this.isDead = true;
                this.updateBlocks();
                DraconicNetwork.sendExplosionEffect((RegistryKey<World>)this.helper.serverWorld.func_234923_W_(), this.helper.start, 0, true);
            }
        }

        public void finishChunks() {
            for (Chunk chunk : this.helper.modifiedChunks) {
                chunk.func_177427_f(true);
                ServerWorldLightManager lightManager = (ServerWorldLightManager)this.helper.serverWorld.func_225524_e_();
                lightManager.func_215593_a((IChunk)chunk, false).thenRun(() -> ((ExplosionHelper)this.helper).serverWorld.func_72863_F().field_217237_a.func_219097_a(chunk.func_76632_l(), false).forEach(e -> e.field_71135_a.func_147359_a((IPacket)new SUpdateLightPacket(chunk.func_76632_l(), this.helper.serverWorld.func_225524_e_(), true))));
                SChunkDataPacket packet = new SChunkDataPacket(chunk, 65535);
                ((ExplosionHelper)this.helper).serverWorld.func_72863_F().field_217237_a.func_219097_a(chunk.func_76632_l(), false).forEach(e -> e.field_71135_a.func_147359_a((IPacket)packet));
            }
            this.helper.modifiedChunks.clear();
        }

        private void updateBlocks() {
            LogHelper.startTimer("Updating Blocks");
            try {
                LogHelper.dev("Updating " + this.helper.blocksToUpdate.size() + " Blocks");
                Iterator iterator = this.helper.blocksToUpdate.iterator();
                while (iterator.hasNext()) {
                    int pos = (Integer)iterator.next();
                    BlockState state = this.helper.serverWorld.func_180495_p(this.helper.shortPos.getActualPos(pos));
                    if (state.func_177230_c() instanceof FallingBlock) {
                        state.func_177230_c().func_225534_a_(state, this.helper.serverWorld, this.helper.shortPos.getActualPos(pos), ((ExplosionHelper)this.helper).serverWorld.field_73012_v);
                    }
                    state.func_215697_a((World)this.helper.serverWorld, this.helper.shortPos.getActualPos(pos), Blocks.field_150350_a, this.helper.shortPos.getActualPos(pos).func_177984_a(), false);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            LogHelper.stopTimer();
        }

        public boolean isDead() {
            return this.isDead;
        }
    }
}

