/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.network;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import com.brandon3055.draconicevolution.api.crafting.IFusionRecipe;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleGrid;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.PropertyData;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import com.brandon3055.draconicevolution.integration.jei.FusionRecipeTransferHelper;
import com.brandon3055.draconicevolution.inventory.ContainerConfigurableItem;
import com.brandon3055.draconicevolution.inventory.ContainerFusionCraftingCore;
import com.brandon3055.draconicevolution.inventory.ContainerModularItem;
import com.brandon3055.draconicevolution.inventory.ContainerModuleHost;
import com.brandon3055.draconicevolution.items.tools.DislocatorAdvanced;
import com.brandon3055.draconicevolution.items.tools.Magnet;
import java.util.ArrayList;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.play.IServerPlayNetHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ServerPacketHandler
implements ICustomPacketHandler.IServerPacketHandler {
    public void handlePacket(PacketCustom packet, ServerPlayerEntity sender, IServerPlayNetHandler handler) {
        switch (packet.getType()) {
            case 1: {
                this.toggleDislocators((PlayerEntity)sender);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.moduleSlotClick((PlayerEntity)sender, (MCDataInput)packet);
                break;
            }
            case 6: {
                this.propertyData(sender, packet);
                break;
            }
            case 7: {
                if (packet.readBoolean()) {
                    ContainerModularItem.tryOpenGui(sender);
                    break;
                }
                ContainerConfigurableItem.tryOpenGui(sender);
                break;
            }
            case 8: {
                ContainerModularItem.tryOpenGui(sender);
                break;
            }
            case 9: {
                this.dislocatorMessage(sender, packet);
                break;
            }
            case 10: {
                this.jeiFusionTransfer(sender, packet);
            }
        }
    }

    private void toggleDislocators(PlayerEntity player) {
        ArrayList<ItemStack> dislocators = new ArrayList<ItemStack>();
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof Magnet)) continue;
            dislocators.add(stack);
        }
        for (ItemStack stack : EquipmentManager.getAllItems((LivingEntity)player)) {
            if (!(stack.func_77973_b() instanceof Magnet)) continue;
            dislocators.add(stack);
        }
        for (ItemStack stack : dislocators) {
            Magnet.toggleEnabled(stack, player);
            boolean enabled = Magnet.isEnabled(stack);
            player.func_146105_b((ITextComponent)new TranslationTextComponent("item_dislocate.draconicevolution." + (enabled ? "activate" : "deactivate")).func_240699_a_(enabled ? TextFormatting.GREEN : TextFormatting.RED), true);
        }
    }

    private void moduleSlotClick(PlayerEntity player, MCDataInput input) {
        ModuleGrid grid;
        if (player.field_71070_bA instanceof ContainerModuleHost && (grid = ((ContainerModuleHost)player.field_71070_bA).getGrid()) != null) {
            ModuleGrid.GridPos pos = grid.getCell(input.readByte(), input.readByte());
            grid.cellClicked(pos, input.readByte(), (ClickType)input.readEnum(ClickType.class));
        }
    }

    private void propertyData(ServerPlayerEntity sender, PacketCustom packet) {
        PropertyData data = PropertyData.read((MCDataInput)packet);
        ContainerConfigurableItem.handlePropertyData((PlayerEntity)sender, data);
    }

    private void dislocatorMessage(ServerPlayerEntity sender, PacketCustom packet) {
        ItemStack stack = DislocatorAdvanced.findDislocator((PlayerEntity)sender);
        if (!stack.func_190926_b()) {
            DEContent.dislocator_advanced.handleClientAction(sender, stack, (MCDataInput)packet);
        }
    }

    private void jeiFusionTransfer(ServerPlayerEntity sender, PacketCustom packet) {
        ResourceLocation id = packet.readResourceLocation();
        boolean maxTransfer = packet.readBoolean();
        IRecipe recipe = sender.field_70170_p.func_199532_z().func_215367_a(id).orElse(null);
        if (recipe instanceof IFusionRecipe && sender.field_71070_bA instanceof ContainerFusionCraftingCore) {
            FusionRecipeTransferHelper.doServerSideTransfer(sender, (ContainerFusionCraftingCore)sender.field_71070_bA, (IFusionRecipe)recipe, maxTransfer);
        }
    }
}

