/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import org.apache.commons.lang3.text.translate.JavaUnicodeEscaper;

public abstract class LanguageProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<String, String> client = new TreeMap<String, String>();
    private final Map<String, String> server = new TreeMap<String, String>();
    private final DataGenerator gen;
    private final String modid;
    private final String locale;
    private final Side distFilter;

    protected LanguageProvider(DataGenerator gen, String modid, String locale, Side distFilter) {
        this.gen = gen;
        this.modid = modid;
        this.locale = locale;
        this.distFilter = distFilter;
    }

    protected abstract void addTranslations();

    public void func_200398_a(DirectoryCache p_200398_1_) throws IOException {
        this.addTranslations();
        if (this.distFilter.includeClient() && !this.client.isEmpty()) {
            this.save(p_200398_1_, this.client, this.gen.func_200391_b().resolve("assets/" + this.modid + "/lang/" + this.locale + ".json"));
        }
        if (this.distFilter.includeServer() && !this.server.isEmpty()) {
            this.save(p_200398_1_, this.server, this.gen.func_200391_b().resolve("data/" + this.modid + "/lang/" + this.locale + ".json"));
        }
    }

    public String func_200397_b() {
        return this.modid + " Languages: " + this.locale;
    }

    private void save(DirectoryCache cache, Object object, Path target) throws IOException {
        String data = GSON.toJson(object);
        data = JavaUnicodeEscaper.outsideOf((int)0, (int)127).translate((CharSequence)data);
        String hash = IDataProvider.field_208307_a.hashUnencodedChars((CharSequence)data).toString();
        if (!Objects.equals(cache.func_208323_a(target), hash) || !Files.exists(target, new LinkOption[0])) {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(target, new OpenOption[0]);){
                bufferedwriter.write(data);
            }
        }
        cache.func_208316_a(target, hash);
    }

    public void add(Block key, String name) {
        this.add(key.func_149739_a(), name);
    }

    public void add(Item key, String name) {
        this.add(key.func_77658_a(), name);
    }

    public void add(ItemStack key, String name) {
        this.add(key.func_77977_a(), name);
    }

    public void add(Enchantment key, String name) {
        this.add(key.func_77320_a(), name);
    }

    public void add(Effect key, String name) {
        this.add(key.func_76393_a(), name);
    }

    public void add(EntityType<?> key, String name) {
        this.add(key.func_210760_d(), name);
    }

    public void addBlock(Supplier<Block> key, String name) {
        this.add(key.get().func_149739_a(), name);
    }

    public void addItem(Supplier<Item> key, String name) {
        this.add(key.get().func_77658_a(), name);
    }

    public void addItemStack(Supplier<ItemStack> key, String name) {
        this.add(key.get().func_77977_a(), name);
    }

    public void addEnchantment(Supplier<Enchantment> key, String name) {
        this.add(key.get().func_77320_a(), name);
    }

    public void addEffect(Supplier<Effect> key, String name) {
        this.add(key.get().func_76393_a(), name);
    }

    public void addEntityType(Supplier<EntityType<?>> key, String name) {
        this.add(key.get().func_210760_d(), name);
    }

    public void add(String key, String name) {
        if (this.client.put(key, name) != null) {
            throw new IllegalArgumentException("Duplicate translation key :" + key);
        }
    }

    public void addServer(String key, String name) {
        this.add(key, name);
        if (this.server.put(key, name) != null) {
            throw new IllegalArgumentException("Duplicate translation key :" + key);
        }
    }

    public static Side getDist(GatherDataEvent event) {
        if (event.includeServer() && event.includeClient()) {
            return Side.BOTH;
        }
        if (event.includeServer()) {
            return Side.SERVER;
        }
        if (event.includeClient()) {
            return Side.CLIENT;
        }
        return Side.NONE;
    }

    public static enum Side {
        CLIENT,
        SERVER,
        BOTH,
        NONE;


        public boolean includeClient() {
            return this == CLIENT || this == BOTH;
        }

        public boolean includeServer() {
            return this == SERVER || this == BOTH;
        }
    }
}

