/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.datagen.recipe;

import codechicken.lib.datagen.recipe.FurnaceRecipeBuilder;
import codechicken.lib.datagen.recipe.RecipeBuilder;
import codechicken.lib.datagen.recipe.ShapedRecipeBuilder;
import codechicken.lib.datagen.recipe.ShapelessRecipeBuilder;
import codechicken.lib.datagen.recipe.SpecialRecipeBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.criterion.EnterBlockTrigger;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class RecipeProvider
implements IDataProvider {
    private static final Logger logger = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Map<ResourceLocation, RecipeBuilder> recipes = new HashMap<ResourceLocation, RecipeBuilder>();
    private final DataGenerator generator;

    public RecipeProvider(DataGenerator generatorIn) {
        this.generator = generatorIn;
    }

    public final void func_200398_a(DirectoryCache cache) throws IOException {
        Path path = this.generator.func_200391_b();
        this.registerRecipes();
        for (Map.Entry<ResourceLocation, RecipeBuilder> entry : this.recipes.entrySet()) {
            ResourceLocation id = entry.getKey();
            IFinishedRecipe finishedRecipe = entry.getValue().build();
            this.saveRecipe(cache, finishedRecipe.func_200441_a(), path.resolve("data/" + id.func_110624_b() + "/recipes/" + id.func_110623_a() + ".json"));
            JsonObject advancement = finishedRecipe.func_200440_c();
            if (advancement == null) continue;
            this.saveRecipeAdvancement(cache, advancement, path.resolve("data/" + id.func_110624_b() + "/advancements/" + id.func_110623_a() + ".json"));
        }
    }

    protected abstract void registerRecipes();

    protected <T extends RecipeBuilder> T builder(T builder) {
        if (this.recipes.containsKey(builder.getId())) {
            throw new IllegalArgumentException("Recipe with id '" + builder.getId() + "' already exists.");
        }
        this.recipes.put(builder.getId(), builder);
        return builder;
    }

    protected ShapedRecipeBuilder shapedRecipe(IItemProvider result) {
        return this.builder(ShapedRecipeBuilder.builder(result, 1));
    }

    protected ShapedRecipeBuilder shapedRecipe(IItemProvider result, int count) {
        return this.builder(ShapedRecipeBuilder.builder(new ItemStack(result, count)));
    }

    protected ShapedRecipeBuilder shapedRecipe(IItemProvider result, int count, ResourceLocation id) {
        return this.builder(ShapedRecipeBuilder.builder(new ItemStack(result, count), id));
    }

    protected ShapedRecipeBuilder shapedRecipe(ItemStack result) {
        return this.builder(ShapedRecipeBuilder.builder(result, result.func_77973_b().getRegistryName()));
    }

    protected ShapedRecipeBuilder shapedRecipe(ItemStack result, ResourceLocation id) {
        return this.builder(ShapedRecipeBuilder.builder(result, id));
    }

    protected ShapelessRecipeBuilder shapelessRecipe(IItemProvider result) {
        return this.builder(ShapelessRecipeBuilder.builder(result, 1));
    }

    protected ShapelessRecipeBuilder shapelessRecipe(IItemProvider result, int count) {
        return this.builder(ShapelessRecipeBuilder.builder(new ItemStack(result, count)));
    }

    protected ShapelessRecipeBuilder shapelessRecipe(IItemProvider result, int count, ResourceLocation id) {
        return this.builder(ShapelessRecipeBuilder.builder(new ItemStack(result, count), id));
    }

    protected ShapelessRecipeBuilder shapelessRecipe(ItemStack result) {
        return this.builder(ShapelessRecipeBuilder.builder(result, result.func_77973_b().getRegistryName()));
    }

    protected ShapelessRecipeBuilder shapelessRecipe(ItemStack result, ResourceLocation id) {
        return this.builder(ShapelessRecipeBuilder.builder(result, id));
    }

    protected FurnaceRecipeBuilder smelting(IItemProvider result) {
        return this.builder(FurnaceRecipeBuilder.smelting(result, 1));
    }

    protected FurnaceRecipeBuilder smelting(IItemProvider result, int count) {
        return this.builder(FurnaceRecipeBuilder.smelting(new ItemStack(result, count)));
    }

    protected FurnaceRecipeBuilder smelting(IItemProvider result, int count, ResourceLocation id) {
        return this.builder(FurnaceRecipeBuilder.smelting(new ItemStack(result, count), id));
    }

    protected FurnaceRecipeBuilder smelting(ItemStack result) {
        return this.builder(FurnaceRecipeBuilder.smelting(result, result.func_77973_b().getRegistryName()));
    }

    protected FurnaceRecipeBuilder smelting(ItemStack result, ResourceLocation id) {
        return this.builder(FurnaceRecipeBuilder.smelting(result, id));
    }

    protected FurnaceRecipeBuilder blasting(IItemProvider result) {
        return this.builder(FurnaceRecipeBuilder.blasting(result, 1));
    }

    protected FurnaceRecipeBuilder blasting(IItemProvider result, int count) {
        return this.builder(FurnaceRecipeBuilder.blasting(new ItemStack(result, count)));
    }

    protected FurnaceRecipeBuilder blasting(IItemProvider result, int count, ResourceLocation id) {
        return this.builder(FurnaceRecipeBuilder.blasting(new ItemStack(result, count), id));
    }

    protected FurnaceRecipeBuilder blasting(ItemStack result) {
        return this.builder(FurnaceRecipeBuilder.blasting(result, result.func_77973_b().getRegistryName()));
    }

    protected FurnaceRecipeBuilder blasting(ItemStack result, ResourceLocation id) {
        return this.builder(FurnaceRecipeBuilder.blasting(result, id));
    }

    protected FurnaceRecipeBuilder smoking(IItemProvider result) {
        return this.builder(FurnaceRecipeBuilder.smoking(result, 1));
    }

    protected FurnaceRecipeBuilder smoking(IItemProvider result, int count) {
        return this.builder(FurnaceRecipeBuilder.smoking(new ItemStack(result, count)));
    }

    protected FurnaceRecipeBuilder smoking(IItemProvider result, int count, ResourceLocation id) {
        return this.builder(FurnaceRecipeBuilder.smoking(new ItemStack(result, count), id));
    }

    protected FurnaceRecipeBuilder smoking(ItemStack result) {
        return this.builder(FurnaceRecipeBuilder.smoking(result, result.func_77973_b().getRegistryName()));
    }

    protected FurnaceRecipeBuilder smoking(ItemStack result, ResourceLocation id) {
        return this.builder(FurnaceRecipeBuilder.smoking(result, id));
    }

    protected FurnaceRecipeBuilder campfire(IItemProvider result) {
        return this.builder(FurnaceRecipeBuilder.campfire(result, 1));
    }

    protected FurnaceRecipeBuilder campfire(IItemProvider result, int count) {
        return this.builder(FurnaceRecipeBuilder.smoking(new ItemStack(result, count)));
    }

    protected FurnaceRecipeBuilder campfire(IItemProvider result, int count, ResourceLocation id) {
        return this.builder(FurnaceRecipeBuilder.campfire(new ItemStack(result, count), id));
    }

    protected FurnaceRecipeBuilder campfire(ItemStack result) {
        return this.builder(FurnaceRecipeBuilder.campfire(result, result.func_77973_b().getRegistryName()));
    }

    protected FurnaceRecipeBuilder campfire(ItemStack result, ResourceLocation id) {
        return this.builder(FurnaceRecipeBuilder.campfire(result, id));
    }

    protected SpecialRecipeBuilder special(SpecialRecipeSerializer<?> serializer, String id) {
        return this.builder(SpecialRecipeBuilder.builder(serializer, id));
    }

    protected SpecialRecipeBuilder special(SpecialRecipeSerializer<?> serializer, ResourceLocation id) {
        return this.builder(SpecialRecipeBuilder.builder(serializer, id));
    }

    private void saveRecipe(DirectoryCache cache, JsonObject recipeJson, Path path) {
        try {
            String json = GSON.toJson((JsonElement)recipeJson);
            String hash = field_208307_a.hashUnencodedChars((CharSequence)json).toString();
            if (!hash.equals(cache.func_208323_a(path)) || !Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                    writer.write(json);
                }
            }
            cache.func_208316_a(path, hash);
        }
        catch (IOException e) {
            logger.error("Couldn't save recipe {}", (Object)path, (Object)e);
        }
    }

    private void saveRecipeAdvancement(DirectoryCache cache, JsonObject advancementJson, Path path) {
        try {
            String json = GSON.toJson((JsonElement)advancementJson);
            String hash = field_208307_a.hashUnencodedChars((CharSequence)json).toString();
            if (!hash.equals(cache.func_208323_a(path)) || !Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                    writer.write(json);
                }
            }
            cache.func_208316_a(path, hash);
        }
        catch (IOException e) {
            logger.error("Couldn't save recipe advancement {}", (Object)path, (Object)e);
        }
    }

    protected EnterBlockTrigger.Instance enteredBlock(Block blockIn) {
        return new EnterBlockTrigger.Instance(EntityPredicate.AndPredicate.field_234582_a_, blockIn, StatePropertiesPredicate.field_227178_a_);
    }

    protected InventoryChangeTrigger.Instance hasItem(IItemProvider itemIn) {
        return this.hasItem(ItemPredicate.Builder.func_200309_a().func_200308_a(itemIn).func_200310_b());
    }

    protected InventoryChangeTrigger.Instance hasItem(ITag<Item> tagIn) {
        return this.hasItem(ItemPredicate.Builder.func_200309_a().func_200307_a(tagIn).func_200310_b());
    }

    protected InventoryChangeTrigger.Instance hasItem(ItemPredicate ... predicates) {
        return new InventoryChangeTrigger.Instance(EntityPredicate.AndPredicate.field_234582_a_, MinMaxBounds.IntBound.field_211347_e, MinMaxBounds.IntBound.field_211347_e, MinMaxBounds.IntBound.field_211347_e, predicates);
    }
}

