/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts;

import com.github.kay9.dragonmounts.DMLConfig;
import com.github.kay9.dragonmounts.DMLRegistry;
import com.github.kay9.dragonmounts.client.DragonEggRenderer;
import com.github.kay9.dragonmounts.client.DragonModel;
import com.github.kay9.dragonmounts.client.DragonRenderer;
import com.github.kay9.dragonmounts.client.EggEntityRenderer;
import com.github.kay9.dragonmounts.data.BreedManager;
import com.github.kay9.dragonmounts.dragon.DMLEggBlock;
import com.github.kay9.dragonmounts.dragon.DragonSpawnEgg;
import com.github.kay9.dragonmounts.dragon.TameableDragon;
import com.github.kay9.dragonmounts.network.UpdateBreedsPacket;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="dragonmounts")
public class DragonMountsLegacy {
    public static final String MOD_ID = "dragonmounts";
    public static final Logger LOG = LogManager.getLogger();
    public static final SimpleChannel NETWORK;

    public DragonMountsLegacy() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        DMLRegistry.init(bus);
        MinecraftForge.EVENT_BUS.addListener(e -> e.addListener((PreparableReloadListener)BreedManager.INSTANCE));
        MinecraftForge.EVENT_BUS.addListener(DragonMountsLegacy::attemptVanillaEggReplacement);
        bus.addListener(e -> e.put((EntityType)DMLRegistry.DRAGON.get(), TameableDragon.createAttributes().m_22265_()));
        if (FMLLoader.getDist() == Dist.CLIENT) {
            MinecraftForge.EVENT_BUS.addListener(e -> DragonMountsLegacy.cameraAngles(e.getCamera()));
            bus.addListener(e -> DragonMountsLegacy.defineBlockModels());
            bus.addListener(e -> e.getItemColors().m_92689_(DragonSpawnEgg::getColor, new ItemLike[]{(ItemLike)DMLRegistry.SPAWN_EGG.get()}));
            bus.addListener(DragonMountsLegacy::rendererRegistry);
        } else {
            MinecraftForge.EVENT_BUS.addListener(e -> UpdateBreedsPacket.send(e.getPlayer()));
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)DMLConfig.COMMON);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)DMLConfig.SERVER);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)DMLConfig.CLIENT);
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    private static void attemptVanillaEggReplacement(PlayerInteractEvent.RightClickBlock evt) {
        if (DMLEggBlock.overrideVanillaDragonEgg(evt.getWorld(), evt.getPos(), evt.getPlayer())) {
            evt.setCanceled(true);
        }
    }

    private static void defineBlockModels() {
        String dir = "models/block/dragon_eggs";
        int length = "models/".length();
        int suffixLength = ".json".length();
        for (ResourceLocation rl : Minecraft.m_91087_().m_91098_().m_6540_(dir, f -> f.endsWith(".json"))) {
            String path = rl.m_135815_();
            ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation(rl.m_135827_(), path.substring(length, path.length() - suffixLength)));
        }
    }

    private static void rendererRegistry(EntityRenderersEvent.RegisterRenderers e) {
        e.registerEntityRenderer((EntityType)DMLRegistry.DRAGON.get(), DragonRenderer::new);
        ForgeHooksClient.registerLayerDefinition((ModelLayerLocation)DragonRenderer.LAYER_LOCATION, DragonModel::createBodyLayer);
        e.registerEntityRenderer((EntityType)DMLRegistry.DRAGON_EGG.get(), EggEntityRenderer::new);
        e.registerBlockEntityRenderer((BlockEntityType)DMLRegistry.EGG_BLOCK_ENTITY.get(), DragonEggRenderer::instance);
    }

    private static void cameraAngles(Camera camera) {
        if (Minecraft.m_91087_().f_91074_.m_20202_() instanceof TameableDragon) {
            int distance = 0;
            int vertical = 0;
            switch (Minecraft.m_91087_().f_91066_.m_92176_()) {
                case THIRD_PERSON_FRONT: {
                    distance = 6;
                    break;
                }
                case THIRD_PERSON_BACK: {
                    distance = 6;
                    vertical = 3;
                }
            }
            camera.m_90568_((double)(-distance), (double)vertical, 0.0);
        }
    }

    static {
        String PROTOCOL_VERSION = "1.O";
        NETWORK = NetworkRegistry.ChannelBuilder.named((ResourceLocation)DragonMountsLegacy.id("network")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
        NETWORK.registerMessage(1, UpdateBreedsPacket.class, UpdateBreedsPacket::encode, UpdateBreedsPacket::new, UpdateBreedsPacket::handle);
    }
}

