/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.client;

import com.github.kay9.dragonmounts.DMLRegistry;
import com.github.kay9.dragonmounts.data.BreedManager;
import com.github.kay9.dragonmounts.dragon.DMLEggBlock;
import com.github.kay9.dragonmounts.dragon.DragonBreed;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.IItemRenderProperties;

public class DragonEggRenderer
extends BlockEntityWithoutLevelRenderer
implements BlockEntityRenderer<DMLEggBlock.Entity>,
IItemRenderProperties {
    public static final DragonEggRenderer INSTANCE = new DragonEggRenderer();
    private static final Map<ResourceLocation, ResourceLocation> MODEL_CACHE = new HashMap<ResourceLocation, ResourceLocation>(8);

    public DragonEggRenderer() {
        super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
    }

    public void m_108829_(ItemStack pStack, ItemTransforms.TransformType pTransformType, PoseStack pPoseStack, MultiBufferSource buffer, int pPackedLight, int pPackedOverlay) {
        DragonBreed breed = BreedManager.getFallback();
        CompoundTag tag = pStack.m_41737_("BlockEntityTag");
        if (tag != null) {
            breed = BreedManager.read(tag.m_128461_("Breed"));
        }
        DragonEggRenderer.renderEgg(pPoseStack, buffer.m_6299_(Sheets.m_110791_()), pPackedLight, breed, false);
    }

    public void render(DMLEggBlock.Entity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource buffer, int pPackedLight, int pPackedOverlay) {
        DragonEggRenderer.renderEgg(pPoseStack, buffer.m_6299_(Sheets.m_110792_()), pPackedLight, pBlockEntity.getBreed(), false);
    }

    public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
        return this;
    }

    public static void renderEgg(PoseStack ps, VertexConsumer consumer, int light, DragonBreed breed, boolean offset) {
        ps.m_85836_();
        if (offset) {
            ps.m_85837_(-0.5, 0.0, -0.5);
        }
        BakedModel model = Minecraft.m_91087_().m_91304_().getModel(MODEL_CACHE.computeIfAbsent(breed.id(), id -> new ResourceLocation(id.m_135827_(), "block/dragon_eggs/" + id.m_135815_() + "_dragon_egg")));
        Minecraft.m_91087_().m_91289_().m_110937_().m_111067_(ps.m_85850_(), consumer, ((Block)DMLRegistry.EGG_BLOCK.get()).m_49966_(), model, 1.0f, 1.0f, 1.0f, light, OverlayTexture.f_118083_);
        ps.m_85849_();
    }

    public static DragonEggRenderer instance(Object context) {
        return INSTANCE;
    }
}

