/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.data;

import com.github.kay9.dragonmounts.DragonMountsLegacy;
import com.github.kay9.dragonmounts.dragon.DragonBreed;
import com.google.common.collect.ImmutableMap;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class BreedManager
extends SimpleJsonResourceReloadListener {
    private static Map<ResourceLocation, DragonBreed> registry = Collections.emptyMap();
    private static DragonBreed fallback = DragonBreed.FIRE;
    public static final BreedManager INSTANCE = new BreedManager();

    protected BreedManager() {
        super(new GsonBuilder().create(), "dragon_breeds");
    }

    protected void apply(Map<ResourceLocation, JsonElement> elements, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        BreedManager.populate(r -> elements.forEach((key, json) -> DragonBreed.CODEC.parse((DynamicOps)JsonOps.INSTANCE, json).resultOrPartial(m -> DragonMountsLegacy.LOG.warn("Failed to load DragonBreed with id '{}': {}", key, m)).ifPresent(r)));
        DragonMountsLegacy.LOG.info("Loaded {} Dragon Breeds", (Object)registry.size());
    }

    public static void populate(Consumer<Consumer<DragonBreed>> registryFunc) {
        HashMap<ResourceLocation, DragonBreed> builder = new HashMap<ResourceLocation, DragonBreed>();
        registryFunc.accept(d -> builder.put(d.id(), (DragonBreed)d));
        fallback = builder.computeIfAbsent(DragonBreed.FIRE.id(), i -> DragonBreed.FIRE);
        registry = ImmutableMap.copyOf(builder);
    }

    @Nonnull
    public static DragonBreed getFallback() {
        return fallback;
    }

    @Nullable
    public static DragonBreed getNullable(ResourceLocation breed) {
        return registry.get(breed);
    }

    public static DragonBreed get(ResourceLocation breed) {
        DragonBreed result = BreedManager.getNullable(breed);
        return result != null ? result : BreedManager.getFallback();
    }

    public static DragonBreed read(String breed) {
        return BreedManager.get(ResourceLocation.m_135820_((String)breed));
    }

    public static Collection<DragonBreed> getBreeds() {
        return registry.values();
    }
}

