/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.data.loot;

import com.github.kay9.dragonmounts.DMLConfig;
import com.github.kay9.dragonmounts.data.BreedManager;
import com.github.kay9.dragonmounts.dragon.DMLEggBlock;
import com.github.kay9.dragonmounts.dragon.DragonBreed;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class DragonEggLootMod
extends LootModifier {
    private final DragonBreed breed;

    public DragonEggLootMod(LootItemCondition[] conditions, DragonBreed breed) {
        super(conditions);
        this.breed = breed;
    }

    @NotNull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (DMLConfig.useLootTables()) {
            generatedLoot.add(DMLEggBlock.Item.create(this.breed, 12000));
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<DragonEggLootMod> {
        public DragonEggLootMod read(ResourceLocation location, JsonObject object, LootItemCondition[] conditions) {
            return new DragonEggLootMod(conditions, BreedManager.read(GsonHelper.m_13906_((JsonObject)object, (String)"breed")));
        }

        public JsonObject write(DragonEggLootMod instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            json.addProperty("breed", instance.breed.id().toString());
            return json;
        }
    }
}

