/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.dragon;

import com.github.kay9.dragonmounts.DragonMountsLegacy;
import com.github.kay9.dragonmounts.abilities.Ability;
import com.github.kay9.dragonmounts.habitats.FluidHabitat;
import com.github.kay9.dragonmounts.habitats.Habitat;
import com.github.kay9.dragonmounts.habitats.NearbyBlocksHabitat;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Vector3f;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.Vec3;

public record DragonBreed(ResourceLocation id, int primaryColor, int secondaryColor, Optional<ParticleOptions> hatchParticles, ModelProperties modelProperties, Map<Attribute, Double> attributes, List<Ability> abilities, List<Habitat> habitats, ImmutableSet<String> immunities, Optional<SoundEvent> specialSound, ResourceLocation deathLoot, int growthTime) {
    public static final Codec<DragonBreed> CODEC = RecordCodecBuilder.create(func -> func.group((App)ResourceLocation.f_135803_.fieldOf("name").forGetter(DragonBreed::id), (App)Codec.INT.fieldOf("primary_color").forGetter(DragonBreed::primaryColor), (App)Codec.INT.fieldOf("secondary_color").forGetter(DragonBreed::secondaryColor), (App)ParticleTypes.f_123791_.optionalFieldOf("hatch_particles").forGetter(DragonBreed::hatchParticles), (App)ModelProperties.CODEC.optionalFieldOf("model_properties", (Object)ModelProperties.STANDARD).forGetter(DragonBreed::modelProperties), (App)Codec.unboundedMap((Codec)Registry.f_122866_.m_194605_(), (Codec)Codec.DOUBLE).optionalFieldOf("attributes", (Object)ImmutableMap.of()).forGetter(DragonBreed::attributes), (App)Ability.CODEC.listOf().optionalFieldOf("abilities", (Object)ImmutableList.of()).forGetter(DragonBreed::abilities), (App)Habitat.CODEC.listOf().optionalFieldOf("habitats", (Object)ImmutableList.of()).forGetter(DragonBreed::habitats), (App)Codec.STRING.listOf().xmap(ImmutableSet::copyOf, ImmutableList::copyOf).optionalFieldOf("immunities", (Object)ImmutableSet.of()).forGetter(DragonBreed::immunities), (App)SoundEvent.f_11655_.optionalFieldOf("ambient_sound").forGetter(DragonBreed::specialSound), (App)ResourceLocation.f_135803_.optionalFieldOf("death_loot", (Object)BuiltInLootTables.f_78712_).forGetter(DragonBreed::deathLoot), (App)Codec.INT.optionalFieldOf("growth_time", (Object)72000).forGetter(DragonBreed::growthTime)).apply((Applicative)func, DragonBreed::new));
    public static final DragonBreed FIRE = new DragonBreed(DragonMountsLegacy.id("fire"), 9511936, 16750617, Optional.of(ParticleTypes.f_123744_), new ModelProperties(false, false, false), (Map<Attribute, Double>)ImmutableMap.of(), (List<Ability>)ImmutableList.of(), (List<Habitat>)ImmutableList.of((Object)new NearbyBlocksHabitat((Tag<Block>)BlockTags.createOptional((ResourceLocation)DragonMountsLegacy.id("fire_dragon_habitat_blocks"))), (Object)new FluidHabitat((Tag<Fluid>)FluidTags.f_13132_)), (ImmutableSet<String>)ImmutableSet.of((Object)"onFire", (Object)"inFire", (Object)"lava", (Object)"hotFloor"), Optional.empty(), BuiltInLootTables.f_78712_, 72000);

    public ParticleOptions getHatchParticles(Random random) {
        return this.hatchParticles().orElseGet(() -> this.getDustParticles(random));
    }

    public DustParticleOptions getDustParticles(Random random) {
        return new DustParticleOptions(new Vector3f(Vec3.m_82501_((int)(random.nextDouble() < 0.75 ? this.primaryColor() : this.secondaryColor()))), 1.0f);
    }

    @Nullable
    public SoundEvent getAmbientSound() {
        return this.specialSound().orElse(null);
    }

    public String getTranslationKey() {
        return "dragon_breed." + this.id().m_135827_() + "." + this.id().m_135815_();
    }

    public int getHabitatPoints(Level level, BlockPos pos) {
        int points = 0;
        for (Habitat habitat : this.habitats()) {
            points += habitat.getHabitatPoints(level, pos);
        }
        return points;
    }

    public record ModelProperties(boolean middleTailScales, boolean tailHorns, boolean thinLegs) {
        public static final ModelProperties STANDARD = new ModelProperties(true, false, false);
        public static Codec<ModelProperties> CODEC = RecordCodecBuilder.create(func -> func.group((App)Codec.BOOL.optionalFieldOf("middle_tail_scales", (Object)true).forGetter(ModelProperties::middleTailScales), (App)Codec.BOOL.optionalFieldOf("tail_horns", (Object)false).forGetter(ModelProperties::tailHorns), (App)Codec.BOOL.optionalFieldOf("thin_legs", (Object)false).forGetter(ModelProperties::thinLegs)).apply((Applicative)func, ModelProperties::new));
    }
}

