/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.habitats;

import com.github.kay9.dragonmounts.habitats.BiomeHabitat;
import com.github.kay9.dragonmounts.habitats.DragonBreathHabitat;
import com.github.kay9.dragonmounts.habitats.FluidHabitat;
import com.github.kay9.dragonmounts.habitats.HeightHabitat;
import com.github.kay9.dragonmounts.habitats.LightHabitat;
import com.github.kay9.dragonmounts.habitats.NearbyBlocksHabitat;
import com.github.kay9.dragonmounts.habitats.PickyHabitat;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public interface Habitat {
    public static final Map<String, Codec<? extends Habitat>> REGISTRY = new HashMap<String, Codec<? extends Habitat>>();
    public static final Codec<Habitat> CODEC = Codec.STRING.dispatch(Habitat::type, REGISTRY::get);
    public static final String PICKY = Habitat.register("picky", PickyHabitat.CODEC);
    public static final String BIOMES = Habitat.register("biome", BiomeHabitat.CODEC);
    public static final String IN_FLUID = Habitat.register("in_fluid", FluidHabitat.CODEC);
    public static final String WORLD_HEIGHT = Habitat.register("world_height", HeightHabitat.CODEC);
    public static final String LIGHT = Habitat.register("light", LightHabitat.CODEC);
    public static final String NEARBY_BLOCKS = Habitat.register("nearby_blocks", NearbyBlocksHabitat.CODEC);
    public static final String DRAGON_BREATH = Habitat.register("dragon_breath", DragonBreathHabitat.CODEC);

    public static String register(String name, Codec<? extends Habitat> codec) {
        REGISTRY.put(name, codec);
        return name;
    }

    public int getHabitatPoints(Level var1, BlockPos var2);

    public String type();
}

