/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.network;

import com.github.kay9.dragonmounts.DragonMountsLegacy;
import com.github.kay9.dragonmounts.abilities.Ability;
import com.github.kay9.dragonmounts.data.BreedManager;
import com.github.kay9.dragonmounts.dragon.DragonBreed;
import com.github.kay9.dragonmounts.habitats.Habitat;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class UpdateBreedsPacket {
    public static final UpdateBreedsPacket INSTANCE = new UpdateBreedsPacket();
    private final Collection<DragonBreed> breeds;

    private UpdateBreedsPacket() {
        this.breeds = Collections.emptyList();
    }

    public UpdateBreedsPacket(FriendlyByteBuf buf) {
        this.breeds = buf.m_178366_(UpdateBreedsPacket::fromBytes);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_178352_(BreedManager.getBreeds(), UpdateBreedsPacket::toBytes);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> BreedManager.populate(this.breeds::forEach));
        ctx.get().setPacketHandled(true);
    }

    private static void toBytes(FriendlyByteBuf buf, DragonBreed breed) {
        buf.m_130085_(breed.id());
        buf.writeInt(breed.primaryColor());
        buf.writeInt(breed.secondaryColor());
        int id = breed.hatchParticles().map(i -> Registry.f_122829_.m_7447_((Object)i.m_6012_())).orElse(-1);
        buf.m_130130_(id);
        if (id != -1) {
            breed.hatchParticles().get().m_7711_(buf);
        }
        DragonBreed.ModelProperties props = breed.modelProperties();
        buf.writeBoolean(props.middleTailScales());
        buf.writeBoolean(props.tailHorns());
        buf.writeBoolean(props.thinLegs());
        buf.writeInt(breed.growthTime());
    }

    private static DragonBreed fromBytes(FriendlyByteBuf buf) {
        return new DragonBreed(buf.m_130281_(), buf.readInt(), buf.readInt(), UpdateBreedsPacket.readPossibleParticle(buf), new DragonBreed.ModelProperties(buf.readBoolean(), buf.readBoolean(), buf.readBoolean()), (Map<Attribute, Double>)ImmutableMap.of(), (List<Ability>)ImmutableList.of(), (List<Habitat>)ImmutableList.of(), (ImmutableSet<String>)ImmutableSet.of(), Optional.empty(), BuiltInLootTables.f_78712_, buf.readInt());
    }

    private static <T extends ParticleOptions> Optional<ParticleOptions> readPossibleParticle(FriendlyByteBuf buf) {
        int id = buf.m_130242_();
        if (id != -1) {
            ParticleType type = (ParticleType)Registry.f_122829_.m_7942_(id);
            return Optional.of(type.m_123743_().m_6507_(type, buf));
        }
        return Optional.empty();
    }

    public static void send(@Nullable ServerPlayer player) {
        PacketDistributor.PacketTarget target = player == null ? PacketDistributor.ALL.noArg() : PacketDistributor.PLAYER.with(() -> player);
        DragonMountsLegacy.NETWORK.send(target, (Object)INSTANCE);
    }
}

