/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.abilities;

import com.github.kay9.dragonmounts.abilities.FrostWalkerAbility;
import com.github.kay9.dragonmounts.abilities.GreenToesAbility;
import com.github.kay9.dragonmounts.abilities.SnowStepperAbility;
import com.github.kay9.dragonmounts.dragon.TameableDragon;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;

public interface Ability {
    public static final Map<String, Codec<? extends Ability>> REGISTRY = new HashMap<String, Codec<? extends Ability>>();
    public static final Codec<Ability> CODEC = Codec.STRING.dispatch(Ability::type, REGISTRY::get);
    public static final String FROST_WALKER = Ability.register("frost_walker", FrostWalkerAbility.CODEC);
    public static final String GREEN_TOES = Ability.register("green_toes", GreenToesAbility.CODEC);
    public static final String SNOW_STEPPER = Ability.register("snow_stepper", SnowStepperAbility.CODEC);

    public static String register(String name, Codec<? extends Ability> codec) {
        REGISTRY.put(name, codec);
        return name;
    }

    default public void initialize(TameableDragon dragon) {
    }

    default public void close(TameableDragon dragon) {
    }

    default public void tick(TameableDragon dragon) {
    }

    default public void onMove(TameableDragon dragon) {
    }

    public String type();
}

