/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.dragon;

import com.github.kay9.dragonmounts.DMLRegistry;
import com.github.kay9.dragonmounts.dragon.breed.BreedRegistry;
import com.github.kay9.dragonmounts.dragon.breed.DragonBreed;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeSpawnEggItem;

public class DragonSpawnEgg
extends ForgeSpawnEggItem {
    public DragonSpawnEgg() {
        super(DMLRegistry.DRAGON, 0, 0, new Item.Properties().m_41491_(CreativeModeTab.f_40753_));
    }

    public void m_6787_(CreativeModeTab pCategory, NonNullList<ItemStack> pItems) {
        if (this.m_220152_(pCategory)) {
            for (DragonBreed breed : BreedRegistry.registry()) {
                pItems.add((Object)DragonSpawnEgg.create(breed));
            }
        }
    }

    public static ItemStack create(DragonBreed breed) {
        CompoundTag root = new CompoundTag();
        CompoundTag entityTag = new CompoundTag();
        entityTag.m_128359_("Breed", breed.id().toString());
        root.m_128365_("EntityTag", (Tag)entityTag);
        CompoundTag itemDataTag = new CompoundTag();
        itemDataTag.m_128359_("ItemName", breed.getTranslationKey());
        itemDataTag.m_128405_("PrimaryColor", breed.primaryColor());
        itemDataTag.m_128405_("SecondaryColor", breed.secondaryColor());
        root.m_128365_("ItemData", (Tag)itemDataTag);
        ItemStack stack = new ItemStack((ItemLike)DMLRegistry.SPAWN_EGG.get());
        stack.m_41751_(root);
        return stack;
    }

    public Component m_7626_(ItemStack stack) {
        String name;
        CompoundTag tag = stack.m_41737_("ItemData");
        if (tag == null || (name = tag.m_128461_("ItemName")).isEmpty()) {
            name = BreedRegistry.getFallback().getTranslationKey();
        }
        return Component.m_237110_((String)this.m_5524_(), (Object[])new Object[]{Component.m_237115_((String)name)});
    }

    public static int getColor(ItemStack stack, int tintIndex) {
        int sec;
        int prim;
        CompoundTag tag = stack.m_41737_("ItemData");
        if (tag != null) {
            prim = tag.m_128451_("PrimaryColor");
            sec = tag.m_128451_("SecondaryColor");
        } else {
            DragonBreed fire = BreedRegistry.getFallback();
            prim = fire.primaryColor();
            sec = fire.secondaryColor();
        }
        return tintIndex == 0 ? prim : sec;
    }
}

