/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.dragon.breed;

import com.github.kay9.dragonmounts.DragonMountsLegacy;
import com.github.kay9.dragonmounts.abilities.Ability;
import com.github.kay9.dragonmounts.dragon.TameableDragon;
import com.github.kay9.dragonmounts.dragon.breed.BreedRegistry;
import com.github.kay9.dragonmounts.habitats.Habitat;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Vector3f;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.Vec3;

public class DragonBreed {
    public static final Codec<DragonBreed> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("primary_color").forGetter(DragonBreed::primaryColor), (App)Codec.INT.fieldOf("secondary_color").forGetter(DragonBreed::secondaryColor), (App)ParticleTypes.f_123791_.optionalFieldOf("hatch_particles").forGetter(DragonBreed::hatchParticles), (App)ModelProperties.CODEC.optionalFieldOf("model_properties", (Object)ModelProperties.STANDARD).forGetter(DragonBreed::modelProperties), (App)Codec.unboundedMap((Codec)Registry.f_122866_.m_194605_(), (Codec)Codec.DOUBLE).optionalFieldOf("attributes", (Object)ImmutableMap.of()).forGetter(DragonBreed::attributes), (App)Ability.CODEC.listOf().optionalFieldOf("abilities", (Object)ImmutableList.of()).forGetter(DragonBreed::abilities), (App)Habitat.CODEC.listOf().optionalFieldOf("habitats", (Object)ImmutableList.of()).forGetter(DragonBreed::habitats), (App)Codec.STRING.listOf().xmap(ImmutableSet::copyOf, ImmutableList::copyOf).optionalFieldOf("immunities", (Object)ImmutableSet.of()).forGetter(DragonBreed::immunities), (App)Registry.f_122821_.m_194605_().optionalFieldOf("ambient_sound").forGetter(DragonBreed::specialSound), (App)ResourceLocation.f_135803_.optionalFieldOf("death_loot", (Object)BuiltInLootTables.f_78712_).forGetter(DragonBreed::deathLoot), (App)Codec.INT.optionalFieldOf("growth_time", (Object)72000).forGetter(DragonBreed::growthTime), (App)Codec.INT.optionalFieldOf("hatch_time", (Object)12000).forGetter(DragonBreed::hatchTime), (App)TagKey.m_203877_((ResourceKey)Registry.f_122904_).optionalFieldOf("taming_items", (Object)ItemTags.f_13156_).forGetter(DragonBreed::tamingItems), (App)TagKey.m_203877_((ResourceKey)Registry.f_122904_).optionalFieldOf("breeding_items", (Object)ItemTags.f_13156_).forGetter(DragonBreed::breedingItems)).apply((Applicative)instance, DragonBreed::new));
    public static final Codec<DragonBreed> NETWORK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("primary_color").forGetter(DragonBreed::primaryColor), (App)Codec.INT.fieldOf("secondary_color").forGetter(DragonBreed::secondaryColor), (App)ParticleTypes.f_123791_.optionalFieldOf("hatch_particles").forGetter(DragonBreed::hatchParticles), (App)ModelProperties.CODEC.fieldOf("model_properties").forGetter(DragonBreed::modelProperties), (App)Registry.f_122821_.m_194605_().optionalFieldOf("ambient_sound").forGetter(DragonBreed::specialSound), (App)Codec.INT.fieldOf("growth_time").forGetter(DragonBreed::growthTime), (App)Codec.INT.fieldOf("hatch_time").forGetter(DragonBreed::hatchTime)).apply((Applicative)instance, DragonBreed::fromNetwork));
    private static final TagKey<Item> EMPTY_TAG = ItemTags.create((ResourceLocation)DragonMountsLegacy.id("empty"));
    private ResourceLocation id;
    private final int primaryColor;
    private final int secondaryColor;
    private final Optional<ParticleOptions> hatchParticles;
    private final ModelProperties modelProperties;
    private final Map<Attribute, Double> attributes;
    private final List<Ability> abilities;
    private final List<Habitat> habitats;
    private final ImmutableSet<String> immunities;
    private final Optional<SoundEvent> specialSound;
    private final ResourceLocation deathLoot;
    private final int growthTime;
    private final int hatchTime;
    private final TagKey<Item> tamingItems;
    private final TagKey<Item> breedingItems;

    public DragonBreed(int primaryColor, int secondaryColor, Optional<ParticleOptions> hatchParticles, ModelProperties modelProperties, Map<Attribute, Double> attributes, List<Ability> abilities, List<Habitat> habitats, ImmutableSet<String> immunities, Optional<SoundEvent> specialSound, ResourceLocation deathLoot, int growthTime, int hatchTime, TagKey<Item> tamingItems, TagKey<Item> breedingItems) {
        this.primaryColor = primaryColor;
        this.secondaryColor = secondaryColor;
        this.hatchParticles = hatchParticles;
        this.modelProperties = modelProperties;
        this.attributes = attributes;
        this.abilities = abilities;
        this.habitats = habitats;
        this.immunities = immunities;
        this.specialSound = specialSound;
        this.deathLoot = deathLoot;
        this.growthTime = growthTime;
        this.hatchTime = hatchTime;
        this.tamingItems = tamingItems;
        this.breedingItems = breedingItems;
    }

    public static DragonBreed builtInUnnamed(int primaryColor, int secondaryColor, Optional<ParticleOptions> hatchParticles, ModelProperties modelProperties, Map<Attribute, Double> attributes, List<Ability> abilities, List<Habitat> habitats, ImmutableSet<String> immunities, Optional<SoundEvent> specialSound) {
        return new DragonBreed(primaryColor, secondaryColor, hatchParticles, modelProperties, attributes, abilities, habitats, immunities, specialSound, BuiltInLootTables.f_78712_, 72000, 12000, (TagKey<Item>)ItemTags.f_13156_, (TagKey<Item>)ItemTags.f_13156_);
    }

    public static DragonBreed builtIn(ResourceLocation name, int primaryColor, int secondaryColor, Optional<ParticleOptions> hatchParticles, ModelProperties modelProperties, Map<Attribute, Double> attributes, List<Ability> abilities, List<Habitat> habitats, ImmutableSet<String> immunities, Optional<SoundEvent> specialSound) {
        DragonBreed breed = DragonBreed.builtInUnnamed(primaryColor, secondaryColor, hatchParticles, modelProperties, attributes, abilities, habitats, immunities, specialSound);
        breed.id = name;
        return breed;
    }

    public static DragonBreed fromNetwork(int primaryColor, int secondaryColor, Optional<ParticleOptions> hatchParticles, ModelProperties modelProperties, Optional<SoundEvent> specialSound, int growthTime, int hatchTime) {
        return new DragonBreed(primaryColor, secondaryColor, hatchParticles, modelProperties, Map.of(), List.of(), List.of(), (ImmutableSet<String>)ImmutableSet.of(), specialSound, BuiltInLootTables.f_78712_, growthTime, hatchTime, EMPTY_TAG, EMPTY_TAG);
    }

    public void initialize(TameableDragon dragon) {
        this.applyAttributes(dragon);
        for (Ability a : this.abilities()) {
            a.initialize(dragon);
        }
    }

    public void close(TameableDragon dragon) {
        dragon.m_21204_().m_22159_(new AttributeMap(TameableDragon.createAttributes().m_22265_()));
        for (Ability a : this.abilities()) {
            a.close(dragon);
        }
    }

    public ParticleOptions getHatchParticles(RandomSource random) {
        return this.hatchParticles().orElseGet(() -> this.getDustParticles(random));
    }

    public DustParticleOptions getDustParticles(RandomSource random) {
        return new DustParticleOptions(new Vector3f(Vec3.m_82501_((int)(random.m_188500_() < 0.75 ? this.primaryColor() : this.secondaryColor()))), 1.0f);
    }

    @Nullable
    public SoundEvent getAmbientSound() {
        return this.specialSound().orElse(null);
    }

    public String getTranslationKey() {
        return "dragon_breed." + this.id().m_135827_() + "." + this.id().m_135815_();
    }

    public int getHabitatPoints(Level level, BlockPos pos) {
        int points = 0;
        for (Habitat habitat : this.habitats()) {
            points += habitat.getHabitatPoints(level, pos);
        }
        return points;
    }

    private void applyAttributes(TameableDragon dragon) {
        float healthPercentile = dragon.m_21223_() / dragon.m_21233_();
        this.attributes().forEach((att, value) -> {
            AttributeInstance inst = dragon.m_21051_((Attribute)att);
            if (inst != null) {
                inst.m_22100_(value.doubleValue());
            }
        });
        dragon.m_21153_(dragon.m_21233_() * healthPercentile);
    }

    public int primaryColor() {
        return this.primaryColor;
    }

    public int secondaryColor() {
        return this.secondaryColor;
    }

    public Optional<ParticleOptions> hatchParticles() {
        return this.hatchParticles;
    }

    public ModelProperties modelProperties() {
        return this.modelProperties;
    }

    public Map<Attribute, Double> attributes() {
        return this.attributes;
    }

    public List<Ability> abilities() {
        return this.abilities;
    }

    public List<Habitat> habitats() {
        return this.habitats;
    }

    public ImmutableSet<String> immunities() {
        return this.immunities;
    }

    public Optional<SoundEvent> specialSound() {
        return this.specialSound;
    }

    public ResourceLocation deathLoot() {
        return this.deathLoot;
    }

    public int growthTime() {
        return this.growthTime;
    }

    public int hatchTime() {
        return this.hatchTime;
    }

    public TagKey<Item> tamingItems() {
        return this.tamingItems;
    }

    public TagKey<Item> breedingItems() {
        return this.breedingItems;
    }

    public String toString() {
        return "DragonBreed{name=\"" + this.id() + "\"}";
    }

    public ResourceLocation id() {
        if (this.id == null) {
            this.id = BreedRegistry.registry().m_7981_((Object)this);
        }
        return this.id;
    }

    public record ModelProperties(boolean middleTailScales, boolean tailHorns, boolean thinLegs) {
        public static final ModelProperties STANDARD = new ModelProperties(true, false, false);
        public static Codec<ModelProperties> CODEC = RecordCodecBuilder.create(func -> func.group((App)Codec.BOOL.optionalFieldOf("middle_tail_scales", (Object)true).forGetter(ModelProperties::middleTailScales), (App)Codec.BOOL.optionalFieldOf("tail_horns", (Object)false).forGetter(ModelProperties::tailHorns), (App)Codec.BOOL.optionalFieldOf("thin_legs", (Object)false).forGetter(ModelProperties::thinLegs)).apply((Applicative)func, ModelProperties::new));
    }
}

