/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.abilities;

import com.github.kay9.dragonmounts.DragonMountsLegacy;
import com.github.kay9.dragonmounts.abilities.FrostWalkerAbility;
import com.github.kay9.dragonmounts.abilities.GreenToesAbility;
import com.github.kay9.dragonmounts.abilities.HotFeetAbility;
import com.github.kay9.dragonmounts.abilities.HydroStepAbility;
import com.github.kay9.dragonmounts.abilities.ReaperStepAbility;
import com.github.kay9.dragonmounts.abilities.SnowStepperAbility;
import com.github.kay9.dragonmounts.dragon.TameableDragon;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public interface Ability {
    public static final Map<ResourceLocation, Codec<? extends Factory<Ability>>> REGISTRY = new HashMap<ResourceLocation, Codec<? extends Factory<Ability>>>();
    public static final Codec<Factory<Ability>> CODEC = ResourceLocation.f_135803_.dispatch(Factory::type, REGISTRY::get);
    public static final ResourceLocation FROST_WALKER = Ability.reg("frost_walker", FrostWalkerAbility.CODEC);
    public static final ResourceLocation GREEN_TOES = Ability.reg("green_toes", GreenToesAbility.CODEC);
    public static final ResourceLocation SNOW_STEPPER = Ability.reg("snow_stepper", SnowStepperAbility.CODEC);
    public static final ResourceLocation HOT_FEET = Ability.reg("hot_feet", HotFeetAbility.CODEC);
    public static final ResourceLocation REAPER_STEP = Ability.reg("reaper_step", ReaperStepAbility.CODEC);
    public static final ResourceLocation HYDRO_STEP = Ability.reg("hydro_step", HydroStepAbility.CODEC);

    public static <T extends Ability> ResourceLocation register(ResourceLocation name, Codec<? extends Factory<T>> codec) {
        REGISTRY.put(name, codec);
        return name;
    }

    private static <T extends Ability> ResourceLocation reg(String name, Codec<? extends Factory<T>> codec) {
        return Ability.register(DragonMountsLegacy.id(name), codec);
    }

    default public void initialize(TameableDragon dragon) {
    }

    default public void close(TameableDragon dragon) {
    }

    default public void tick(TameableDragon dragon) {
    }

    default public void onMove(TameableDragon dragon) {
    }

    public static <T extends Ability> Factory<T> simpleFactory(final ResourceLocation id, final Supplier<T> factory) {
        return new Factory<T>(){

            @Override
            public T create() {
                return (Ability)factory.get();
            }

            @Override
            public ResourceLocation type() {
                return id;
            }
        };
    }

    public static interface Factory<T extends Ability> {
        public T create();

        public ResourceLocation type();
    }
}

