/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.client;

import com.github.kay9.dragonmounts.accessors.ModelPartAccess;
import com.github.kay9.dragonmounts.client.DragonAnimator;
import com.github.kay9.dragonmounts.client.ModelPartProxy;
import com.github.kay9.dragonmounts.dragon.TameableDragon;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.NoSuchElementException;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import org.jetbrains.annotations.Nullable;

public class DragonModel
extends EntityModel<TameableDragon> {
    public static final int NECK_SIZE = 10;
    public static final int TAIL_SIZE = 10;
    public static final int VERTS_NECK = 7;
    public static final int VERTS_TAIL = 12;
    public static final int HEAD_OFS = -16;
    public final ModelPart head;
    public final ModelPart neck;
    public final ModelPart neckScale;
    public final ModelPart tail;
    public final ModelPart tailHornLeft;
    public final ModelPart tailHornRight;
    public final ModelPart jaw;
    public final ModelPart body;
    public final ModelPart back;
    public final ModelPart[][] legs = new ModelPart[4][4];
    public final ModelPart[] wingArms;
    public final ModelPart[] wingForearms;
    public final ModelPart[][] wingFingers = new ModelPart[2][4];
    public final ModelPartProxy[] neckProxy = new ModelPartProxy[7];
    public final ModelPartProxy[] tailProxy = new ModelPartProxy[12];
    public float size;

    public DragonModel(ModelPart root) {
        super(RenderType::m_110452_);
        int i;
        this.body = root.m_171324_("body");
        this.back = this.body.m_171324_("back");
        this.neck = root.m_171324_("neck");
        this.neckScale = this.neck.m_171324_("neck_scale");
        this.head = root.m_171324_("head");
        this.jaw = this.head.m_171324_("jaw");
        this.tail = root.m_171324_("tail");
        this.tailHornRight = DragonModel.getNullableChild(this.tail, "right_tail_spike");
        this.tailHornLeft = DragonModel.getNullableChild(this.tail, "left_tail_spike");
        ModelPart rightWingArm = root.m_171324_("right_wing_arm");
        ModelPart leftWingArm = root.m_171324_("left_wing_arm");
        ModelPart rightWingForearm = rightWingArm.m_171324_("right_wing_forearm");
        ModelPart leftWingForearm = leftWingArm.m_171324_("left_wing_forearm");
        this.wingArms = new ModelPart[]{rightWingArm, leftWingArm};
        this.wingForearms = new ModelPart[]{rightWingForearm, leftWingForearm};
        for (i = 1; i < 5; ++i) {
            this.wingFingers[0][i - 1] = rightWingForearm.m_171324_("right_wing_finger_" + i);
            this.wingFingers[1][i - 1] = leftWingForearm.m_171324_("left_wing_finger_" + i);
        }
        for (i = 0; i < this.legs.length; ++i) {
            boolean right = i < 2;
            String dirName = right ? "right_" : "left_";
            String type = i % 2 == 0 ? "fore_" : "hind_";
            String[] parts = new String[]{"thigh", "crus", "foot", "toe"};
            ModelPart parent = root;
            for (int j = 0; j < parts.length; ++j) {
                ModelPart modelPart = parent.m_171324_(dirName + type + parts[j]);
                this.legs[i][j] = modelPart;
                parent = modelPart;
            }
        }
        for (i = 0; i < this.neckProxy.length; ++i) {
            this.neckProxy[i] = new ModelPartProxy(this.neck);
        }
        for (i = 0; i < this.tailProxy.length; ++i) {
            this.tailProxy[i] = new ModelPartProxy(this.tail);
        }
        if (this.tailHornRight != null) {
            this.tailHornLeft.f_104207_ = false;
            this.tailHornRight.f_104207_ = false;
        }
    }

    public static LayerDefinition createBodyLayer(Properties properties) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        DragonModel.buildBody(root);
        DragonModel.buildNeck(root);
        DragonModel.buildHead(root);
        DragonModel.buildTail(root, properties);
        DragonModel.buildWings(root);
        DragonModel.buildLegs(root, properties);
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)256, (int)256);
    }

    private static void buildBody(PartDefinition root) {
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-12.0f, 0.0f, -16.0f, 24.0f, 24.0f, 64.0f).m_171514_(0, 32).m_171481_(-1.0f, -6.0f, 10.0f, 2.0f, 6.0f, 12.0f).m_171481_(-1.0f, -6.0f, 30.0f, 2.0f, 6.0f, 12.0f), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)8.0f));
        body.m_171599_("back", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171481_(-1.0f, -6.0f, -10.0f, 2.0f, 6.0f, 12.0f), PartPose.f_171404_);
    }

    private static void buildNeck(PartDefinition root) {
        PartDefinition neck = root.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(112, 88).m_171481_(-5.0f, -5.0f, -5.0f, 10.0f, 10.0f, 10.0f), PartPose.f_171404_);
        neck.m_171599_("neck_scale", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.0f, -7.0f, -3.0f, 2.0f, 4.0f, 6.0f), PartPose.f_171404_);
    }

    private static void buildHead(PartDefinition root) {
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(56, 88).m_171481_(-6.0f, -1.0f, -24.0f, 12.0f, 5.0f, 16.0f).m_171514_(0, 0).m_171481_(-8.0f, -8.0f, -10.0f, 16.0f, 16.0f, 16.0f).m_171514_(48, 0).m_171481_(-5.0f, -3.0f, -22.0f, 2.0f, 2.0f, 4.0f).m_171480_().m_171481_(3.0f, -3.0f, -22.0f, 2.0f, 2.0f, 4.0f), PartPose.f_171404_);
        DragonModel.addHorns(head);
        head.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(0, 88).m_171481_(-6.0f, 0.0f, -16.0f, 12.0f, 4.0f, 16.0f), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)-8.0f));
    }

    private static void addHorns(PartDefinition head) {
        int hornThick = 3;
        int hornLength = 12;
        float hornOfs = -((float)hornThick / 2.0f);
        float hornPosX = -5.0f;
        float hornPosY = -8.0f;
        float hornPosZ = 0.0f;
        float hornRotX = 0.523599f;
        float hornRotY = -0.523599f;
        float hornRotZ = 0.0f;
        head.m_171599_("horn1", CubeListBuilder.m_171558_().m_171514_(28, 32).m_171481_(hornOfs, hornOfs, hornOfs, (float)hornThick, (float)hornThick, (float)hornLength), PartPose.m_171423_((float)hornPosX, (float)hornPosY, (float)hornPosZ, (float)hornRotX, (float)hornRotY, (float)hornRotZ));
        head.m_171599_("horn2", CubeListBuilder.m_171558_().m_171514_(28, 32).m_171480_().m_171481_(hornOfs, hornOfs, hornOfs, (float)hornThick, (float)hornThick, (float)hornLength), PartPose.m_171423_((float)(hornPosX * -1.0f), (float)hornPosY, (float)hornPosZ, (float)hornRotX, (float)(hornRotY * -1.0f), (float)hornRotZ));
    }

    private static void buildTail(PartDefinition root, Properties properties) {
        PartDefinition tail = root.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(152, 88).m_171481_(-5.0f, -5.0f, -5.0f, 10.0f, 10.0f, 10.0f), PartPose.f_171404_);
        CubeListBuilder tailSpikeCube = CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.0f, -8.0f, -3.0f, 2.0f, 4.0f, 6.0f);
        if (properties.middleTailScales()) {
            tail.m_171599_("middle_tail_scale", tailSpikeCube, PartPose.f_171404_);
        } else {
            tail.m_171599_("left_tail_scale", tailSpikeCube, PartPose.m_171430_((float)0.0f, (float)0.0f, (float)0.785398f));
            tail.m_171599_("right_tail_scale", tailSpikeCube, PartPose.m_171430_((float)0.0f, (float)0.0f, (float)-0.785398f));
        }
        if (properties.tailHorns()) {
            DragonModel.addTailSpikes(tail);
        }
    }

    private static void addTailSpikes(PartDefinition tail) {
        int hornThick = 3;
        int hornLength = 32;
        float hornOfs = -((float)hornThick / 2.0f);
        float hornPosX = 0.0f;
        float hornPosY = hornOfs;
        float hornPosZ = 5.0f;
        float hornRotX = -0.261799f;
        float hornRotY = -2.53073f;
        float hornRotZ = 0.0f;
        tail.m_171599_("right_tail_spike", CubeListBuilder.m_171558_().m_171514_(0, 117).m_171481_(hornOfs, hornOfs, hornOfs, (float)hornThick, (float)hornThick, (float)hornLength), PartPose.m_171423_((float)hornPosX, (float)hornPosY, (float)hornPosZ, (float)hornRotX, (float)hornRotY, (float)hornRotZ));
        tail.m_171599_("left_tail_spike", CubeListBuilder.m_171558_().m_171514_(0, 117).m_171480_().m_171481_(hornOfs, hornOfs, hornOfs, (float)hornThick, (float)hornThick, (float)hornLength), PartPose.m_171423_((float)(hornPosX * -1.0f), (float)hornPosY, (float)hornPosZ, (float)hornRotX, (float)(hornRotY * -1.0f), (float)hornRotZ));
    }

    private static void buildWings(PartDefinition root) {
        DragonModel.buildWing(root, false);
        DragonModel.buildWing(root, true);
    }

    private static void buildWing(PartDefinition root, boolean mirror) {
        String direction = mirror ? "left_" : "right_";
        CubeListBuilder wingArmCube = CubeListBuilder.m_171558_().m_171555_(mirror);
        DragonModel.centerMirroredBox(wingArmCube.m_171514_(0, 152), mirror, -28.0f, -3.0f, -3.0f, 28.0f, 6.0f, 6.0f);
        DragonModel.centerMirroredBox(wingArmCube.m_171514_(116, 232), mirror, -28.0f, 0.0f, 2.0f, 28.0f, 0.0f, 24.0f);
        CubeListBuilder foreArmCube = DragonModel.centerMirroredBox(CubeListBuilder.m_171558_().m_171555_(mirror).m_171514_(0, 164), mirror, -48.0f, -2.0f, -2.0f, 48.0f, 4.0f, 4.0f);
        CubeListBuilder shortSkinCube = CubeListBuilder.m_171558_().m_171555_(mirror);
        DragonModel.centerMirroredBox(shortSkinCube.m_171514_(0, 172), mirror, -70.0f, -1.0f, -1.0f, 70.0f, 2.0f, 2.0f);
        DragonModel.centerMirroredBox(shortSkinCube.m_171514_(-49, 176), mirror, -70.0f, 0.0f, 1.0f, 70.0f, 0.0f, 48.0f);
        PartPose shortSkinPos = DragonModel.mirrorXPos(-47.0f, 0.0f, 0.0f, mirror);
        CubeListBuilder lastFingerCube = CubeListBuilder.m_171558_().m_171555_(mirror);
        DragonModel.centerMirroredBox(lastFingerCube.m_171514_(0, 172), mirror, -70.0f, -1.0f, -1.0f, 70.0f, 2.0f, 2.0f);
        DragonModel.centerMirroredBox(lastFingerCube.m_171514_(-32, 224), mirror, -70.0f, 0.0f, 1.0f, 70.0f, 0.0f, 32.0f);
        PartDefinition arm = root.m_171599_(direction + "wing_arm", wingArmCube, DragonModel.mirrorXPos(-10.0f, 5.0f, 4.0f, mirror));
        PartDefinition foreArm = arm.m_171599_(direction + "wing_forearm", foreArmCube, DragonModel.mirrorXPos(-28.0f, 0.0f, 0.0f, mirror));
        for (int j = 1; j < 4; ++j) {
            foreArm.m_171599_(direction + "wing_finger_" + j, shortSkinCube, shortSkinPos);
        }
        foreArm.m_171599_(direction + "wing_finger_4", lastFingerCube, shortSkinPos);
    }

    private static void buildLegs(PartDefinition root, Properties properties) {
        DragonModel.buildLeg(root, false, properties.thinLegs(), false);
        DragonModel.buildLeg(root, true, properties.thinLegs(), false);
        DragonModel.buildLeg(root, false, properties.thinLegs(), true);
        DragonModel.buildLeg(root, true, properties.thinLegs(), true);
    }

    private static void buildLeg(PartDefinition root, boolean hind, boolean thin, boolean mirror) {
        float baseLength = 26.0f;
        String baseName = (mirror ? "left_" : "right_") + (hind ? "hind_" : "fore_");
        float thighPosX = -11.0f;
        float thighPosY = 18.0f;
        float thighPosZ = 4.0f;
        int thighThick = 9 - (thin ? 2 : 0);
        int thighLength = (int)(baseLength * (hind ? 0.9f : 0.77f));
        if (hind) {
            ++thighThick;
            thighPosY -= 5.0f;
        }
        float thighOfs = -((float)thighThick / 2.0f);
        PartDefinition thigh = root.m_171599_(baseName + "thigh", CubeListBuilder.m_171558_().m_171514_(112, hind ? 29 : 0).m_171481_(thighOfs, thighOfs, thighOfs, (float)thighThick, (float)thighLength, (float)thighThick), DragonModel.mirrorXPos(thighPosX, thighPosY, thighPosZ, mirror));
        float crusPosX = 0.0f;
        float crusPosY = (float)thighLength + thighOfs;
        float crusPosZ = 0.0f;
        int crusThick = thighThick - 2;
        int crusLength = (int)(baseLength * (hind ? 0.7f : 0.8f));
        if (hind) {
            --crusThick;
            crusLength -= 2;
        }
        float crusOfs = -((float)crusThick / 2.0f);
        PartDefinition crus = thigh.m_171599_(baseName + "crus", CubeListBuilder.m_171558_().m_171514_(hind ? 152 : 148, hind ? 29 : 0).m_171481_(crusOfs, crusOfs, crusOfs, (float)crusThick, (float)crusLength, (float)crusThick), DragonModel.mirrorXPos(crusPosX, crusPosY, crusPosZ, mirror));
        float footPosX = 0.0f;
        float footPosY = (float)crusLength + crusOfs / 2.0f;
        float footPosZ = 0.0f;
        int footWidth = crusThick + 2 + (thin ? 2 : 0);
        int footHeight = 4;
        int footLength = (int)(baseLength * (hind ? 0.67f : 0.34f));
        float footOfsX = -((float)footWidth / 2.0f);
        float footOfsY = -((float)footHeight / 2.0f);
        float footOfsZ = (float)footLength * -0.75f;
        PartDefinition foot = crus.m_171599_(baseName + "foot", CubeListBuilder.m_171558_().m_171514_(hind ? 180 : 210, hind ? 29 : 0).m_171481_(footOfsX, footOfsY, footOfsZ, (float)footWidth, (float)footHeight, (float)footLength), DragonModel.mirrorXPos(footPosX, footPosY, footPosZ, mirror));
        int toeWidth = footWidth;
        int toeHeight = footHeight;
        int toeLength = (int)(baseLength * (hind ? 0.27f : 0.33f));
        float toePosX = 0.0f;
        float toePosY = 0.0f;
        float toePosZ = footOfsZ - footOfsY / 2.0f;
        float toeOfsX = -((float)toeWidth / 2.0f);
        float toeOfsY = -((float)toeHeight / 2.0f);
        float toeOfsZ = -toeLength;
        foot.m_171599_(baseName + "toe", CubeListBuilder.m_171558_().m_171514_(hind ? 215 : 176, hind ? 29 : 0).m_171481_(toeOfsX, toeOfsY, toeOfsZ, (float)toeWidth, (float)toeHeight, (float)toeLength), DragonModel.mirrorXPos(toePosX, toePosY, toePosZ, mirror));
    }

    public void prepareMobModel(TameableDragon dragon, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        this.size = Math.min(dragon.m_6134_(), 1.0f);
        dragon.getAnimator().setPartialTicks(pPartialTick);
    }

    public void setupAnim(TameableDragon dragon, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        DragonAnimator animator = dragon.getAnimator();
        animator.setLook(pNetHeadYaw, pHeadPitch);
        animator.setMovement(pLimbSwing, pLimbSwingAmount * dragon.m_6134_());
        dragon.getAnimator().animate(this);
    }

    public void m_7695_(PoseStack ps, VertexConsumer vertices, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        this.body.m_104306_(ps, vertices, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
        this.renderHead(ps, vertices, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
        for (ModelPartProxy proxy : this.neckProxy) {
            proxy.render(ps, vertices, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
        }
        for (ModelPartProxy proxy : this.tailProxy) {
            proxy.render(ps, vertices, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
        }
        this.renderWings(ps, vertices, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
        this.renderLegs(ps, vertices, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
    }

    protected void renderHead(PoseStack ps, VertexConsumer vertices, int packedLight, int packedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        float headScale = 1.4f / (this.size + 0.4f);
        ((ModelPartAccess)this.head).setRenderScale(headScale, headScale, headScale);
        this.head.m_104306_(ps, vertices, packedLight, packedOverlay, pRed, pGreen, pBlue, pAlpha);
    }

    public void renderWings(PoseStack ps, VertexConsumer vertices, int packedLight, int packedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        ps.m_85836_();
        ps.m_85841_(1.1f, 1.1f, 1.1f);
        this.wingArms[0].m_104306_(ps, vertices, packedLight, packedOverlay, pRed, pGreen, pBlue, pAlpha);
        this.wingArms[1].m_104306_(ps, vertices, packedLight, packedOverlay, pRed, pGreen, pBlue, pAlpha);
        ps.m_85849_();
    }

    protected void renderLegs(PoseStack ps, VertexConsumer vertices, int packedLight, int packedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        for (ModelPart[] leg : this.legs) {
            leg[0].m_104306_(ps, vertices, packedLight, packedOverlay, pRed, pGreen, pBlue, pAlpha);
        }
    }

    private static CubeListBuilder centerMirroredBox(CubeListBuilder builder, boolean mirror, float pOriginX, float pOriginY, float pOriginZ, float pDimensionX, float pDimensionY, float pDimensionZ) {
        if (mirror) {
            pOriginX = 0.0f;
        }
        return builder.m_171481_(pOriginX, pOriginY, pOriginZ, pDimensionX, pDimensionY, pDimensionZ);
    }

    private static PartPose mirrorXPos(float x, float y, float z, boolean mirror) {
        if (mirror) {
            x = -x;
        }
        return PartPose.m_171419_((float)x, (float)y, (float)z);
    }

    @Nullable
    private static ModelPart getNullableChild(ModelPart parent, String child) {
        try {
            return parent.m_171324_(child);
        }
        catch (NoSuchElementException ignore) {
            return null;
        }
    }

    public record Properties(boolean middleTailScales, boolean tailHorns, boolean thinLegs) {
        public static final Properties STANDARD = new Properties(true, false, false);
        public static final Codec<Properties> CODEC = RecordCodecBuilder.create(func -> func.group((App)Codec.BOOL.optionalFieldOf("middle_tail_scales", (Object)true).forGetter(Properties::middleTailScales), (App)Codec.BOOL.optionalFieldOf("tail_horns", (Object)false).forGetter(Properties::tailHorns), (App)Codec.BOOL.optionalFieldOf("thin_legs", (Object)false).forGetter(Properties::thinLegs)).apply((Applicative)func, Properties::new));
    }
}

