/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.data.loot;

import com.github.kay9.dragonmounts.DragonMountsLegacy;
import com.github.kay9.dragonmounts.dragon.DMLEggBlock;
import com.github.kay9.dragonmounts.dragon.breed.BreedRegistry;
import com.github.kay9.dragonmounts.dragon.breed.DragonBreed;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class DragonEggLootMod
extends LootModifier {
    public static Target[] BUILT_IN_CHANCES = new Target[]{new Target(DragonBreed.BuiltIn.AETHER, BuiltInLootTables.f_78742_, 0.2), new Target(DragonBreed.BuiltIn.FIRE, BuiltInLootTables.f_78764_, 0.085), new Target(DragonBreed.BuiltIn.FOREST, BuiltInLootTables.f_78686_, 0.3), new Target(DragonBreed.BuiltIn.GHOST, BuiltInLootTables.f_78689_, 0.2), new Target(DragonBreed.BuiltIn.GHOST, BuiltInLootTables.f_78759_, 0.075), new Target(DragonBreed.BuiltIn.ICE, BuiltInLootTables.f_78688_, 0.2), new Target(DragonBreed.BuiltIn.NETHER, BuiltInLootTables.f_78697_, 0.35), new Target(DragonBreed.BuiltIn.WATER, BuiltInLootTables.f_78692_, 0.175)};
    private final ResourceLocation id;

    public DragonEggLootMod(LootItemCondition[] conditions, ResourceLocation breed) {
        super(conditions);
        this.id = breed;
    }

    @NotNull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        RegistryAccess reg = context.m_78952_().m_5962_();
        DragonBreed breed = (DragonBreed)BreedRegistry.registry(reg).m_7745_(this.id);
        if (breed != null) {
            generatedLoot.add(DMLEggBlock.Item.create(breed, reg, breed.hatchTime()));
        } else {
            DragonMountsLegacy.LOG.error("Attempted to add a dragon egg to loot with unknown breed id: \"{}\"", (Object)this.id);
        }
        return generatedLoot;
    }

    public record Target(ResourceKey<DragonBreed> forBreed, ResourceLocation target, double chance) {
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<DragonEggLootMod> {
        public DragonEggLootMod read(ResourceLocation location, JsonObject object, LootItemCondition[] conditions) {
            String in = GsonHelper.m_13906_((JsonObject)object, (String)"egg_breed");
            return new DragonEggLootMod(conditions, new ResourceLocation(in));
        }

        public JsonObject write(DragonEggLootMod instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            json.addProperty("egg_breed", instance.id.toString());
            return json;
        }
    }
}

