/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.dragon.ai;

import com.github.kay9.dragonmounts.dragon.TameableDragon;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;

public class DragonFollowOwnerGoal
extends Goal {
    private static final int MIN_HORIZONTAL_DISTANCE_FROM_PLAYER_WHEN_TELEPORTING = 2;
    private static final int MAX_HORIZONTAL_DISTANCE_FROM_PLAYER_WHEN_TELEPORTING = 3;
    private static final int MIN_VERTICAL_DISTANCE_FROM_PLAYER_WHEN_TELEPORTING = 0;
    private static final int MAX_VERTICAL_DISTANCE_FROM_PLAYER_WHEN_TELEPORTING = 1;
    private final TameableDragon dragon;
    private LivingEntity owner;
    private final LevelReader level;
    private final double speedModifier;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;
    private final float teleportDistance;
    private float oldWaterCost;

    public DragonFollowOwnerGoal(TameableDragon dragon, double speedModifier, float startDistance, float stopDistance, float teleportDistance) {
        this.dragon = dragon;
        this.level = dragon.f_19853_;
        this.speedModifier = speedModifier;
        this.startDistance = startDistance;
        this.stopDistance = stopDistance;
        this.teleportDistance = teleportDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity livingentity = this.dragon.m_142480_();
        if (livingentity == null) {
            return false;
        }
        if (livingentity.m_5833_()) {
            return false;
        }
        if (this.dragon.m_21827_()) {
            return false;
        }
        if (this.dragon.m_20280_((Entity)livingentity) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = livingentity;
        return true;
    }

    public boolean m_8045_() {
        if (this.dragon.m_21573_().m_26571_()) {
            return false;
        }
        if (this.dragon.m_21827_()) {
            return false;
        }
        return this.dragon.m_20280_((Entity)this.owner) >= (double)(this.stopDistance * this.stopDistance);
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.dragon.m_21439_(BlockPathTypes.WATER);
        this.dragon.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.dragon.m_21573_().m_26573_();
        this.dragon.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        this.dragon.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.dragon.m_8132_());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.m_183277_(10);
            if (!this.dragon.m_21523_() && !this.dragon.m_20159_()) {
                if (this.dragon.m_20280_((Entity)this.owner) >= (double)(this.teleportDistance * this.teleportDistance)) {
                    this.teleportToOwner();
                } else if (!this.dragon.m_142592_() && this.dragon.canFly() && (float)(this.owner.m_142538_().m_123342_() - this.dragon.m_142538_().m_123342_()) >= this.startDistance) {
                    this.dragon.liftOff();
                } else {
                    this.dragon.m_21573_().m_5624_((Entity)this.owner, this.speedModifier);
                }
            }
        }
    }

    private void teleportToOwner() {
        BlockPos ownerPos = this.owner.m_142538_();
        for (int i = 0; i < 10; ++i) {
            BlockPos target = this.randomBlockPosNearPos(ownerPos, 2, 3, 0, 1);
            boolean flag = this.maybeTeleportTo(target);
            if (!flag) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(BlockPos pos) {
        if (this.owner.m_142538_().m_123314_((Vec3i)pos, 2.0)) {
            return false;
        }
        if (!this.canTeleportTo(pos)) {
            return false;
        }
        this.dragon.m_7678_((double)pos.m_123341_() + 0.5, pos.m_123342_(), pos.m_123343_(), this.dragon.m_146908_(), this.dragon.m_146909_());
        this.dragon.m_21573_().m_26573_();
        return true;
    }

    private boolean canTeleportTo(BlockPos pos) {
        if (!this.dragon.canFly()) {
            BlockPathTypes blockpathtypes = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)pos.m_122032_());
            if (blockpathtypes != BlockPathTypes.WALKABLE) {
                return false;
            }
            BlockState blockstate = this.level.m_8055_(pos.m_7495_());
            if (blockstate.m_60734_() instanceof LeavesBlock) {
                return false;
            }
        }
        BlockPos blockPos = pos.m_141950_((Vec3i)this.dragon.m_142538_());
        AABB targetBoundingBox = this.dragon.m_142469_().m_82338_(blockPos);
        return this.level.m_45756_((Entity)this.dragon, targetBoundingBox) && !this.level.m_46855_(targetBoundingBox);
    }

    private int randomIntInclusive(int min, int max) {
        return this.dragon.m_21187_().nextInt(max - min + 1) + min;
    }

    private int randomIntInclusive(int farLow, int nearLow, int nearHigh, int farHigh) {
        if (nearLow == nearHigh) {
            return this.randomIntInclusive(farLow, farHigh);
        }
        return this.dragon.m_21187_().nextBoolean() ? this.randomIntInclusive(farLow, nearLow) : this.randomIntInclusive(nearHigh, farHigh);
    }

    private BlockPos randomBlockPosNearPos(BlockPos origin, int minDist, int maxDist, int minYDist, int maxYDist) {
        int x = this.randomIntInclusive(-maxDist, -minDist, minDist, maxDist);
        int y = this.randomIntInclusive(-maxYDist, -minYDist, minYDist, maxYDist);
        int z = this.randomIntInclusive(-maxDist, -minDist, minDist, maxDist);
        return origin.m_142082_(x, y, z);
    }
}

