/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.habitats;

import com.github.kay9.dragonmounts.DragonMountsLegacy;
import com.github.kay9.dragonmounts.habitats.BiomeHabitat;
import com.github.kay9.dragonmounts.habitats.DragonBreathHabitat;
import com.github.kay9.dragonmounts.habitats.FluidHabitat;
import com.github.kay9.dragonmounts.habitats.HeightHabitat;
import com.github.kay9.dragonmounts.habitats.LightHabitat;
import com.github.kay9.dragonmounts.habitats.NearbyBlocksHabitat;
import com.github.kay9.dragonmounts.habitats.PickyHabitat;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public interface Habitat {
    public static final Map<ResourceLocation, Codec<? extends Habitat>> REGISTRY = new HashMap<ResourceLocation, Codec<? extends Habitat>>();
    public static final Codec<Habitat> CODEC = ResourceLocation.f_135803_.dispatch(Habitat::type, REGISTRY::get);
    public static final ResourceLocation PICKY = Habitat.reg("picky", PickyHabitat.CODEC);
    public static final ResourceLocation BIOMES = Habitat.reg("biome", BiomeHabitat.CODEC);
    public static final ResourceLocation IN_FLUID = Habitat.reg("in_fluid", FluidHabitat.CODEC);
    public static final ResourceLocation WORLD_HEIGHT = Habitat.reg("world_height", HeightHabitat.CODEC);
    public static final ResourceLocation LIGHT = Habitat.reg("light", LightHabitat.CODEC);
    public static final ResourceLocation NEARBY_BLOCKS = Habitat.reg("nearby_blocks", NearbyBlocksHabitat.CODEC);
    public static final ResourceLocation DRAGON_BREATH = Habitat.reg("dragon_breath", DragonBreathHabitat.CODEC);

    public static ResourceLocation register(ResourceLocation name, Codec<? extends Habitat> codec) {
        REGISTRY.put(name, codec);
        return name;
    }

    private static ResourceLocation reg(String name, Codec<? extends Habitat> codec) {
        return Habitat.register(DragonMountsLegacy.id(name), codec);
    }

    public static <T extends Habitat> RecordCodecBuilder<T, Integer> withPoints(int defaultTo, Function<T, Integer> getter) {
        return Codec.INT.optionalFieldOf("points", (Object)defaultTo).forGetter(getter);
    }

    public static <T extends Habitat> RecordCodecBuilder<T, Float> withMultiplier(float defaultTo, Function<T, Float> getter) {
        return Codec.FLOAT.optionalFieldOf("point_multiplier", (Object)Float.valueOf(defaultTo)).forGetter(getter);
    }

    public int getHabitatPoints(Level var1, BlockPos var2);

    public ResourceLocation type();
}

