/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts;

import net.minecraftforge.common.ForgeConfigSpec;

public class DMLConfig {
    static final ForgeConfigSpec COMMON;
    private static final ForgeConfigSpec.BooleanValue ALLOW_EGG_OVERRIDE;
    static final ForgeConfigSpec SERVER;
    private static final ForgeConfigSpec.BooleanValue REPLENISH_EGGS;
    private static final ForgeConfigSpec.BooleanValue USE_LOOT_TABLES;
    private static final ForgeConfigSpec.BooleanValue UPDATE_HABITATS;
    private static final ForgeConfigSpec.IntValue REPRO_LIMIT;
    public static boolean cameraFlight;

    public static boolean allowEggOverride() {
        return (Boolean)ALLOW_EGG_OVERRIDE.get();
    }

    public static boolean replenishEggs() {
        return (Boolean)REPLENISH_EGGS.get();
    }

    public static boolean useLootTables() {
        return (Boolean)USE_LOOT_TABLES.get();
    }

    public static boolean updateHabitats() {
        return (Boolean)UPDATE_HABITATS.get();
    }

    public static int reproLimit() {
        return (Integer)REPRO_LIMIT.get();
    }

    public static boolean cameraFlight() {
        return cameraFlight;
    }

    static {
        ForgeConfigSpec.Builder configurator = new ForgeConfigSpec.Builder();
        ALLOW_EGG_OVERRIDE = configurator.comment(new String[]{"Allow the vanilla ender egg to be interacted with? (Hatchable)", "Useful to help with mod compatability"}).define("allow_egg_override", true);
        COMMON = configurator.build();
        configurator = new ForgeConfigSpec.Builder();
        REPLENISH_EGGS = configurator.comment(new String[]{"Should Ender Dragon Eggs replenish on the exit portal after a respawned dragon is deafeated?", "Useful for multiplayer scenarios."}).define("replenish_eggs", true);
        USE_LOOT_TABLES = configurator.comment(new String[]{"Should dragon eggs generate in treasure chest loot tables?", "Useful for multiplayer scenarios and offering alternative ways to obtain eggs.", "Different types of egg breeds can be found in different chests (if configured.)"}).define("use_loot_tables", false);
        UPDATE_HABITATS = configurator.comment("Should Dragon Eggs adapt to their environments and change breeds?").define("update_habitats", true);
        REPRO_LIMIT = configurator.comment("Number of times a dragon is able to breed.").defineInRange("breed_limit", 2, 0, Integer.MAX_VALUE);
        SERVER = configurator.build();
    }
}

