/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.client;

import com.github.kay9.dragonmounts.dragon.egg.HatchableEggBlockEntity;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DragonEggModel
implements IUnbakedGeometry<DragonEggModel> {
    private final ImmutableMap<String, BlockModel> models;

    public DragonEggModel(ImmutableMap<String, BlockModel> models) {
        this.models = models;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        ImmutableMap.Builder baked = ImmutableMap.builder();
        for (Map.Entry entry : this.models.entrySet()) {
            BlockModel unbaked = (BlockModel)entry.getValue();
            unbaked.m_5500_(arg_0 -> ((ModelBaker)baker).m_245361_(arg_0));
            baked.put((Object)((String)entry.getKey()), (Object)unbaked.m_111449_(baker, unbaked, spriteGetter, modelState, modelLocation, true));
        }
        return new Baked((ImmutableMap<String, BakedModel>)baked.build(), overrides);
    }

    public static class Baked
    implements IDynamicBakedModel {
        private static final Supplier<BakedModel> FALLBACK = Suppliers.memoize(() -> Minecraft.m_91087_().m_91289_().m_110910_(Blocks.f_50260_.m_49966_()));
        private final ImmutableMap<String, BakedModel> models;
        private final ItemOverrides overrides;

        public Baked(ImmutableMap<String, BakedModel> models, ItemOverrides overrides) {
            this.models = models;
            this.overrides = new ItemModelResolver(this, overrides);
        }

        @NotNull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
            Data data = (Data)extraData.get(Data.PROPERTY);
            if (data != null) {
                return ((BakedModel)this.models.get((Object)data.breedId())).getQuads(state, side, rand, extraData, renderType);
            }
            return FALLBACK.get().getQuads(state, side, rand, extraData, renderType);
        }

        public boolean m_7541_() {
            return true;
        }

        public boolean m_7539_() {
            return true;
        }

        public boolean m_7547_() {
            return true;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return FALLBACK.get().m_6160_();
        }

        public TextureAtlasSprite getParticleIcon(@NotNull ModelData modelData) {
            Data data = (Data)modelData.get(Data.PROPERTY);
            if (data != null) {
                return ((BakedModel)this.models.get((Object)data.breedId())).getParticleIcon(modelData);
            }
            return this.m_6160_();
        }

        public ItemOverrides m_7343_() {
            return this.overrides;
        }

        public BakedModel applyTransform(ItemDisplayContext transformType, PoseStack poseStack, boolean applyLeftHandTransform) {
            return FALLBACK.get().applyTransform(transformType, poseStack, applyLeftHandTransform);
        }

        @NotNull
        public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
            HatchableEggBlockEntity e;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof HatchableEggBlockEntity && (e = (HatchableEggBlockEntity)blockEntity).getBreed() != null) {
                return modelData.derive().with(Data.PROPERTY, (Object)new Data(e.getBreed().id(Minecraft.m_91087_().f_91073_.m_9598_()).toString())).build();
            }
            return modelData;
        }
    }

    public static class Loader
    implements IGeometryLoader<DragonEggModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public DragonEggModel read(JsonObject jsonObject, JsonDeserializationContext deserializer) throws JsonParseException {
            ImmutableMap.Builder models = ImmutableMap.builder();
            String dir = "models/block/dragon_eggs";
            int length = "models/".length();
            int suffixLength = ".json".length();
            for (Map.Entry entry : Minecraft.m_91087_().m_91098_().m_214159_(dir, f -> f.m_135815_().endsWith(".json")).entrySet()) {
                ResourceLocation rl = (ResourceLocation)entry.getKey();
                String path = rl.m_135815_();
                path = path.substring(length, path.length() - suffixLength);
                String id = String.format("%s:%s", rl.m_135827_(), path.substring("block/dragon_eggs/".length(), path.length() - "_dragon_egg".length()));
                try {
                    BufferedReader reader = ((Resource)entry.getValue()).m_215508_();
                    try {
                        models.put((Object)id, (Object)BlockModel.m_111461_((Reader)reader));
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (IOException e) {
                    throw new JsonParseException((Throwable)e);
                }
            }
            return new DragonEggModel((ImmutableMap<String, BlockModel>)models.build());
        }
    }

    public static class ItemModelResolver
    extends ItemOverrides {
        private final Baked owner;
        private final ItemOverrides nested;

        public ItemModelResolver(Baked owner, ItemOverrides nested) {
            this.owner = owner;
            this.nested = nested;
        }

        @Nullable
        public BakedModel m_173464_(BakedModel original, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int pSeed) {
            BakedModel model;
            BakedModel override = this.nested.m_173464_(original, stack, level, entity, pSeed);
            if (override != original) {
                return override;
            }
            CompoundTag tag = BlockItem.m_186336_((ItemStack)stack);
            if (tag != null && (model = (BakedModel)this.owner.models.get((Object)tag.m_128461_("Breed"))) != null) {
                return model;
            }
            return original;
        }
    }

    private record Data(String breedId) {
        private static final ModelProperty<Data> PROPERTY = new ModelProperty();
    }
}

