/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.data.loot;

import com.github.kay9.dragonmounts.DMLConfig;
import com.github.kay9.dragonmounts.DragonMountsLegacy;
import com.github.kay9.dragonmounts.dragon.breed.BreedRegistry;
import com.github.kay9.dragonmounts.dragon.egg.HatchableEggBlock;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class DragonEggLootMod
extends LootModifier {
    public static final Codec<DragonEggLootMod> CODEC = RecordCodecBuilder.create(i -> DragonEggLootMod.codecStart((RecordCodecBuilder.Instance)i).and((App)ResourceLocation.f_135803_.fieldOf("breed").forGetter(m -> m.id)).apply((Applicative)i, DragonEggLootMod::new));
    private final ResourceLocation id;

    public DragonEggLootMod(LootItemCondition[] conditions, ResourceLocation breed) {
        super(conditions);
        this.id = breed;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (DMLConfig.useLootTables()) {
            RegistryAccess.Frozen reg = context.m_78952_().m_7654_().m_206579_();
            BreedRegistry.registry((RegistryAccess)reg).m_6612_(this.id).ifPresentOrElse(breed -> generatedLoot.add((Object)HatchableEggBlock.Item.create(breed, (RegistryAccess)reg)), () -> DragonMountsLegacy.LOG.error("Unable to produce Dragon Egg Loot with unknown breed id: \"" + this.id + "\""));
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

