/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.dragon;

import com.github.kay9.dragonmounts.DMLRegistry;
import com.github.kay9.dragonmounts.dragon.breed.BreedRegistry;
import com.github.kay9.dragonmounts.dragon.breed.DragonBreed;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

public class DragonSpawnEgg
extends ForgeSpawnEggItem {
    public DragonSpawnEgg() {
        super(DMLRegistry.DRAGON, 0, 0, new Item.Properties());
    }

    public static ItemStack create(DragonBreed breed, RegistryAccess reg) {
        CompoundTag root = new CompoundTag();
        CompoundTag entityTag = new CompoundTag();
        entityTag.m_128359_("Breed", breed.id(reg).toString());
        root.m_128365_("EntityTag", (Tag)entityTag);
        CompoundTag itemDataTag = new CompoundTag();
        itemDataTag.m_128359_("ItemName", DragonBreed.getTranslationKey(breed.id(reg).toString()));
        itemDataTag.m_128405_("PrimaryColor", breed.primaryColor());
        itemDataTag.m_128405_("SecondaryColor", breed.secondaryColor());
        root.m_128365_("ItemData", (Tag)itemDataTag);
        ItemStack stack = new ItemStack((ItemLike)DMLRegistry.SPAWN_EGG.get());
        stack.m_41751_(root);
        return stack;
    }

    public static void populateTab(CreativeModeTabEvent.BuildContents evt) {
        if (Minecraft.m_91087_().f_91073_ != null) {
            RegistryAccess reg = Minecraft.m_91087_().f_91073_.m_9598_();
            for (DragonBreed breed : BreedRegistry.registry(reg)) {
                evt.m_246342_(DragonSpawnEgg.create(breed, reg));
            }
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        DragonSpawnEgg.preconditionSpawnEgg(stack);
        return super.initCapabilities(stack, nbt);
    }

    public Component m_7626_(ItemStack stack) {
        String name = "";
        CompoundTag tag = stack.m_41737_("ItemData");
        if (tag != null) {
            name = tag.m_128461_("ItemName");
        }
        return Component.m_237110_((String)this.m_5524_(), (Object[])new Object[]{Component.m_237115_((String)name)});
    }

    public static int getColor(ItemStack stack, int tintIndex) {
        CompoundTag tag = stack.m_41737_("ItemData");
        if (tag != null) {
            return tintIndex == 0 ? tag.m_128451_("PrimaryColor") : tag.m_128451_("SecondaryColor");
        }
        return 0xFFFFFF;
    }

    private static void preconditionSpawnEgg(ItemStack stack) {
        if (ServerLifecycleHooks.getCurrentServer() == null) {
            return;
        }
        CompoundTag root = stack.m_41784_();
        CompoundTag blockEntityData = stack.m_41698_("EntityTag");
        String breedId = blockEntityData.m_128461_("Breed");
        RegistryAccess.Frozen regAcc = ServerLifecycleHooks.getCurrentServer().m_206579_();
        Registry<DragonBreed> reg = BreedRegistry.registry((RegistryAccess)regAcc);
        if (breedId.isEmpty() || !reg.m_7804_(new ResourceLocation(breedId))) {
            Holder.Reference breed = (Holder.Reference)reg.m_213642_(RandomSource.m_216327_()).orElseThrow();
            ItemStack updated = DragonSpawnEgg.create((DragonBreed)breed.get(), (RegistryAccess)regAcc);
            root.m_128391_(updated.m_41783_());
        }
    }
}

