/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.dragon.egg;

import com.github.kay9.dragonmounts.DMLRegistry;
import com.github.kay9.dragonmounts.dragon.breed.BreedRegistry;
import com.github.kay9.dragonmounts.dragon.breed.DragonBreed;
import com.github.kay9.dragonmounts.dragon.egg.HatchableEggBlock;
import com.github.kay9.dragonmounts.habitats.Habitat;
import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Nameable;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class HatchableEggBlockEntity
extends BlockEntity
implements Nameable {
    public static final int MIN_HABITAT_POINTS = 2;
    public static final int BREED_TRANSITION_TIME = 200;
    private final TransitionHandler transitioner = new TransitionHandler();
    private Supplier<DragonBreed> breed = () -> null;
    private Component customName;

    public HatchableEggBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)DMLRegistry.EGG_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.getBreed() != null) {
            tag.m_128359_("Breed", this.getBreed().id(this.m_58904_().m_9598_()).toString());
        }
        if (this.m_7770_() != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        if (this.getTransition().isRunning()) {
            CompoundTag transitionTag = new CompoundTag();
            this.getTransition().save(transitionTag);
            tag.m_128365_("TransitionerTag", (Tag)transitionTag);
        }
    }

    public void m_142466_(CompoundTag pTag) {
        CompoundTag transitioner;
        super.m_142466_(pTag);
        this.setBreed((Supplier<DragonBreed>)Suppliers.memoize(() -> BreedRegistry.get(pTag.m_128461_("Breed"), this.m_58904_().m_9598_())));
        String name = pTag.m_128461_("CustomName");
        if (!name.isBlank()) {
            this.setCustomName((Component)Component.Serializer.m_130701_((String)name));
        }
        if (!(transitioner = pTag.m_128469_("TransitionerTag")).m_128456_()) {
            this.getTransition().load(transitioner);
        }
        if (this.m_58904_() != null && this.m_58904_().m_5776_()) {
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 8);
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        if (this.getBreed() == null) {
            this.setBreed((Supplier<DragonBreed>)Suppliers.memoize(() -> BreedRegistry.getRandom(this.m_58904_().m_9598_(), this.m_58904_().m_213780_())));
        }
        this.m_183515_(tag);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public DragonBreed getBreed() {
        return this.breed.get();
    }

    public void setBreed(Supplier<DragonBreed> breed) {
        this.breed = breed;
    }

    public Component m_7770_() {
        return this.customName;
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : Component.m_237110_((String)((Item)DMLRegistry.EGG_BLOCK_ITEM.get()).m_5524_(), (Object[])new Object[]{Component.m_237115_((String)DragonBreed.getTranslationKey(this.getBreed().id(this.m_58904_().m_9598_()).toString()))});
    }

    public void setCustomName(Component name) {
        this.customName = name;
    }

    public TransitionHandler getTransition() {
        return this.transitioner;
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        this.getTransition().tick(this.m_58904_().m_213780_());
    }

    public void updateHabitat() {
        DragonBreed winner = null;
        int prevPoints = 0;
        for (DragonBreed breed : BreedRegistry.registry(this.m_58904_().m_9598_())) {
            int points = 0;
            for (Habitat habitat : breed.habitats()) {
                points += habitat.getHabitatPoints(this.f_58857_, this.m_58899_());
            }
            if (points <= 2 || points <= prevPoints) continue;
            winner = breed;
            prevPoints = points;
        }
        if (winner != null && winner != this.getBreed()) {
            this.getTransition().begin(winner);
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 8);
        }
    }

    public class TransitionHandler {
        private static final String NBT_TRANSITIONER = "TransitionerTag";
        private static final String NBT_TRANSITION_BREED = "TransitionBreed";
        private static final String NBT_TRANSITION_TIME = "TransitionTime";
        public Supplier<DragonBreed> transitioningBreed;
        public int transitionTime;

        public void tick(RandomSource random) {
            if (this.isRunning()) {
                if (--this.transitionTime == 0) {
                    HatchableEggBlockEntity.this.setBreed(this.transitioningBreed);
                    HatchableEggBlockEntity.this.m_58904_().m_7260_(HatchableEggBlockEntity.this.m_58899_(), HatchableEggBlockEntity.this.m_58900_(), HatchableEggBlockEntity.this.m_58900_(), 8);
                }
                if (HatchableEggBlockEntity.this.m_58904_().f_46443_) {
                    int i = 0;
                    while ((double)i < (double)(200 - this.transitionTime) * 0.25) {
                        BlockPos pos = HatchableEggBlockEntity.this.m_58899_();
                        double px = (double)pos.m_123341_() + random.m_188500_();
                        double py = (double)pos.m_123342_() + random.m_188500_();
                        double pz = (double)pos.m_123343_() + random.m_188500_();
                        DustParticleOptions particle = HatchableEggBlock.dustParticleFor(this.transitioningBreed.get(), random);
                        HatchableEggBlockEntity.this.m_58904_().m_7106_((ParticleOptions)particle, px, py, pz, 0.0, 0.0, 0.0);
                        ++i;
                    }
                }
            }
        }

        public void startFrom(Supplier<DragonBreed> transitioningBreed, int transitionTime) {
            this.transitioningBreed = transitioningBreed;
            this.transitionTime = transitionTime;
        }

        public void begin(DragonBreed transitioningBreed) {
            this.startFrom(() -> transitioningBreed, 200);
        }

        public boolean isRunning() {
            return this.transitionTime > 0;
        }

        public void save(CompoundTag tag) {
            tag.m_128359_(NBT_TRANSITION_BREED, this.transitioningBreed.get().id(HatchableEggBlockEntity.this.m_58904_().m_9598_()).toString());
            tag.m_128405_(NBT_TRANSITION_TIME, this.transitionTime);
        }

        public void load(CompoundTag tag) {
            this.startFrom((Supplier<DragonBreed>)Suppliers.memoize(() -> BreedRegistry.get(tag.m_128461_(NBT_TRANSITION_BREED), HatchableEggBlockEntity.this.m_58904_().m_9598_())), tag.m_128451_(NBT_TRANSITION_TIME));
        }
    }
}

