/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.data.model;

import com.github.kay9.dragonmounts.DragonMountsLegacy;
import com.github.kay9.dragonmounts.client.DragonModel;
import com.github.kay9.dragonmounts.client.DragonRenderer;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.client.ForgeHooksClient;
import org.apache.logging.log4j.Logger;

public class DragonModelPropertiesListener
extends SimpleJsonResourceReloadListener {
    public static final DragonModelPropertiesListener INSTANCE = new DragonModelPropertiesListener();
    private static final String FOLDER = "models/entity/dragon/breed/properties";
    private final Map<ResourceLocation, ModelLayerLocation> definitions = new HashMap<ResourceLocation, ModelLayerLocation>(3);

    public DragonModelPropertiesListener() {
        super(new GsonBuilder().create(), FOLDER);
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        this.definitions.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            ResourceLocation breedId = entry.getKey();
            DragonModel.Properties properties = (DragonModel.Properties)DragonModel.Properties.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).getOrThrow(false, Util.m_137489_((String)("Unable to parse Dragon Breed Properties: " + breedId), arg_0 -> ((Logger)DragonMountsLegacy.LOG).error(arg_0)));
            ModelLayerLocation modelLoc = new ModelLayerLocation(DragonRenderer.MODEL_LOCATION.m_171123_(), breedId.toString());
            ForgeHooksClient.registerLayerDefinition((ModelLayerLocation)modelLoc, () -> DragonModel.createBodyLayer(properties));
            this.definitions.put(entry.getKey(), modelLoc);
        }
    }

    public Map<ResourceLocation, ModelLayerLocation> pollDefinitions() {
        Map<ResourceLocation, ModelLayerLocation> map = Map.copyOf(this.definitions);
        this.definitions.clear();
        return map;
    }
}

