/*
 * Decompiled with CFR 0.152.
 */
package com.baguchan.enchantwithmob;

import com.baguchan.enchantwithmob.EnchantConfig;
import com.baguchan.enchantwithmob.capability.MobEnchantCapability;
import com.baguchan.enchantwithmob.capability.MobEnchantStorage;
import com.baguchan.enchantwithmob.client.ClientRegistrar;
import com.baguchan.enchantwithmob.message.MobEnchantedMessage;
import com.baguchan.enchantwithmob.message.RemoveMobEnchantMessage;
import com.baguchan.enchantwithmob.registry.ModEntities;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="enchantwithmob")
public class EnchantWithMob {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "enchantwithmob";
    public static final String NETWORK_PROTOCOL = "2";
    @CapabilityInject(value=MobEnchantCapability.class)
    public static final Capability<MobEnchantCapability> MOB_ENCHANT_CAP = null;
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("enchantwithmob", "net")).networkProtocolVersion(() -> "2").clientAcceptedVersions("2"::equals).serverAcceptedVersions("2"::equals).simpleChannel();

    public EnchantWithMob() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        this.setupMessages();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientRegistrar::loadComplete));
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, EnchantConfig.COMMON_SPEC);
    }

    private void setup(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(MobEnchantCapability.class, new MobEnchantStorage(), MobEnchantCapability::new);
    }

    private void setupMessages() {
        CHANNEL.messageBuilder(MobEnchantedMessage.class, 0).encoder(MobEnchantedMessage::serialize).decoder(MobEnchantedMessage::deserialize).consumer(MobEnchantedMessage::handle).add();
        CHANNEL.messageBuilder(RemoveMobEnchantMessage.class, 1).encoder(RemoveMobEnchantMessage::serialize).decoder(RemoveMobEnchantMessage::deserialize).consumer(RemoveMobEnchantMessage::handle).add();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        ModEntities.setupEntitiesClient();
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
    }
}

