/*
 * Decompiled with CFR 0.152.
 */
package com.baguchan.enchantwithmob.capability;

import com.baguchan.enchantwithmob.EnchantWithMob;
import com.baguchan.enchantwithmob.capability.MobEnchantHandler;
import com.baguchan.enchantwithmob.message.MobEnchantedMessage;
import com.baguchan.enchantwithmob.message.RemoveMobEnchantMessage;
import com.baguchan.enchantwithmob.mobenchant.MobEnchant;
import com.baguchan.enchantwithmob.utils.MobEnchantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.PacketDistributor;

public class MobEnchantCapability
implements ICapabilityProvider,
ICapabilitySerializable<CompoundNBT> {
    public List<MobEnchantHandler> mobEnchants = Lists.newArrayList();

    public void addMobEnchant(LivingEntity entity, MobEnchant mobEnchant, int enchantLevel) {
        this.mobEnchants.add(new MobEnchantHandler(mobEnchant, enchantLevel));
        this.onNewEnchantEffect(entity, mobEnchant, enchantLevel);
        if (!entity.field_70170_p.field_72995_K) {
            MobEnchantedMessage message = new MobEnchantedMessage((Entity)entity, mobEnchant, enchantLevel);
            EnchantWithMob.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)message);
        }
    }

    public void removeMobEnchant(LivingEntity entity, MobEnchant mobEnchant, int level) {
        this.mobEnchants.remove((Object)mobEnchant);
        this.onRemoveEnchantEffect(entity, mobEnchant);
        if (!entity.field_70170_p.field_72995_K) {
            RemoveMobEnchantMessage message = new RemoveMobEnchantMessage((Entity)entity, mobEnchant, level);
            EnchantWithMob.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)message);
        }
    }

    public void removeMobEnchantFromOwner(LivingEntity entity, MobEnchant mobEnchant, int level) {
        this.mobEnchants.remove((Object)mobEnchant);
        this.onRemoveEnchantEffect(entity, mobEnchant);
        if (!entity.field_70170_p.field_72995_K) {
            RemoveMobEnchantMessage message = new RemoveMobEnchantMessage((Entity)entity, mobEnchant, level);
            EnchantWithMob.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)message);
        }
    }

    protected void onNewEnchantEffect(LivingEntity entity, MobEnchant enchant, int enchantLevel) {
        if (!entity.field_70170_p.field_72995_K) {
            enchant.applyAttributesModifiersToEntity(entity, entity.func_233645_dx_(), enchantLevel);
        }
    }

    protected void onChangedEnchantEffect(LivingEntity entity, MobEnchant enchant, int enchantLevel) {
        if (!entity.field_70170_p.field_72995_K) {
            enchant.applyAttributesModifiersToEntity(entity, entity.func_233645_dx_(), enchantLevel);
        }
    }

    protected void onRemoveEnchantEffect(LivingEntity entity, MobEnchant enchant) {
        if (!entity.field_70170_p.field_72995_K) {
            enchant.removeAttributesModifiersFromEntity(entity, entity.func_233645_dx_());
        }
    }

    public List<MobEnchantHandler> getMobEnchants() {
        return this.mobEnchants;
    }

    public boolean hasEnchant() {
        return !this.mobEnchants.isEmpty();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        return capability == EnchantWithMob.MOB_ENCHANT_CAP ? LazyOptional.of(() -> this).cast() : LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        ListNBT listnbt = new ListNBT();
        for (int i = 0; i < this.mobEnchants.size(); ++i) {
            listnbt.add((Object)this.mobEnchants.get(i).writeNBT());
        }
        nbt.func_218657_a("StoredMobEnchants", (INBT)listnbt);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        ListNBT list = MobEnchantUtils.getEnchantmentListForNBT(nbt);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT compoundnbt = list.func_150305_b(i);
            this.mobEnchants.add(new MobEnchantHandler(MobEnchantUtils.getEnchantFromNBT(compoundnbt), MobEnchantUtils.getEnchantLevelFromNBT(compoundnbt)));
        }
    }
}

