/*
 * Decompiled with CFR 0.152.
 */
package gigabit101.EnderBags;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeHelper
implements IResourceManagerReloadListener {
    private int j = 0;
    private final String modid;
    private final String modname;
    private final List<IRecipe> recipes = new LinkedList<IRecipe>();

    public RecipeHelper(String modid, String modname) {
        this.modid = modid;
        this.modname = modname;
        MinecraftForge.EVENT_BUS.addListener(this::serverStart);
    }

    public void addRecipe(IRecipe rec) {
        this.recipes.add(rec);
    }

    public void addShapeless(Object output, Object ... inputs) {
        this.addRecipe((IRecipe)new ShapelessRecipe(new ResourceLocation(this.modid + ":" + this.j++), this.modid, RecipeHelper.makeStack(output), this.createInput(false, inputs)));
    }

    public void addShaped(Object output, int width, int height, Object ... input) {
        this.addRecipe((IRecipe)this.genShaped(RecipeHelper.makeStack(output), width, height, input));
    }

    public ShapedRecipe genShaped(ItemStack output, int l, int w, Object ... input) {
        if (l * w != input.length) {
            throw new UnsupportedOperationException("Attempted to add invalid shaped recipe.  Complain to the author of " + this.modname);
        }
        return new ShapedRecipe(new ResourceLocation(this.modid + ":" + this.j++), this.modid, l, w, this.createInput(true, input), output);
    }

    public NonNullList<Ingredient> createInput(boolean allowEmpty, Object ... input) {
        NonNullList inputL = NonNullList.func_191196_a();
        for (int i = 0; i < input.length; ++i) {
            Object k = input[i];
            if (k instanceof String) {
                inputL.add(i, (Object)Ingredient.func_199805_a((Tag)ItemTags.func_199903_a().func_199910_a(new ResourceLocation((String)k))));
                continue;
            }
            if (k instanceof ItemStack && !((ItemStack)k).func_190926_b()) {
                inputL.add(i, (Object)CachedIngredient.create((ItemStack)k));
                continue;
            }
            if (k instanceof IForgeRegistryEntry) {
                inputL.add(i, (Object)CachedIngredient.create(RecipeHelper.makeStack(k)));
                continue;
            }
            if (k instanceof Ingredient) {
                inputL.add(i, (Object)((Ingredient)k));
                continue;
            }
            if (allowEmpty) {
                inputL.add(i, (Object)Ingredient.field_193370_a);
                continue;
            }
            throw new UnsupportedOperationException("Attempted to add invalid shapeless recipe.  Complain to the author of " + this.modname);
        }
        return inputL;
    }

    public void addSimpleShapeless(Object output, Object input, int numInputs) {
        this.addShapeless(output, NonNullList.func_191197_a((int)numInputs, (Object)RecipeHelper.makeStack(input)));
    }

    public List<IRecipe> getRecipes() {
        return this.recipes;
    }

    public static ItemStack makeStack(Object thing, int size) {
        if (thing instanceof ItemStack) {
            return (ItemStack)thing;
        }
        if (thing instanceof Item) {
            return new ItemStack((IItemProvider)((Item)thing), size);
        }
        if (thing instanceof Block) {
            return new ItemStack((IItemProvider)((Block)thing), size);
        }
        throw new IllegalArgumentException("Attempted to create an ItemStack from something that cannot be converted: " + thing);
    }

    public static ItemStack makeStack(Object thing) {
        return RecipeHelper.makeStack(thing, 1);
    }

    public void func_195410_a(IResourceManager resourceManager) {
        if (!ServerLifecycleHooks.getCurrentServer().func_71218_a(DimensionType.OVERWORLD).func_72912_H().func_197719_N().contains("mod:" + this.modid)) {
            this.recipes.forEach(arg_0 -> ((RecipeManager)ServerLifecycleHooks.getCurrentServer().func_199529_aN()).func_199509_a(arg_0));
        }
    }

    @SubscribeEvent
    public void serverStart(FMLServerStartingEvent e) {
        e.getServer().func_195570_aG().func_199006_a((IResourceManagerReloadListener)this);
    }

    public static class CachedIngredient
    extends Ingredient {
        public static Int2ObjectMap<CachedIngredient> ing = new Int2ObjectOpenHashMap();

        protected CachedIngredient(ItemStack ... matches) {
            super(Arrays.stream(matches).map(s -> new Ingredient.SingleItemList(s)));
            if (matches.length == 1) {
                ing.put(RecipeItemHelper.func_194113_b((ItemStack)matches[0]), (Object)this);
            }
        }

        public static CachedIngredient create(ItemStack ... matches) {
            if (matches.length == 1) {
                CachedIngredient coi = (CachedIngredient)((Object)ing.get(RecipeItemHelper.func_194113_b((ItemStack)matches[0])));
                return coi != null ? coi : new CachedIngredient(matches);
            }
            return new CachedIngredient(matches);
        }
    }
}

