/*
 * Decompiled with CFR 0.152.
 */
package gigabit101.EnderBags.config;

import gigabit101.EnderBags.EnderBags;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="ender_bags")
public class EnderBagConfig {
    public static final ForgeConfigSpec SPEC;
    public static final EnderBagConfig INSTANCE;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> blacklist;
    public final List<Item> realBlacklist = new ArrayList<Item>();

    public EnderBagConfig(ForgeConfigSpec.Builder build) {
        build.comment("Server configuration");
        build.push("server");
        ArrayList<String> def = new ArrayList<String>();
        for (EnumDyeColor e : EnumDyeColor.values()) {
            def.add("ender_bags:" + e.func_176610_l() + "_bag");
        }
        this.blacklist = build.comment("A list of item registry names that are not allowed in ender bags.  Format is modid:name.").defineList("blacklist", def, x -> true);
        build.pop();
    }

    public void parseBlacklist() {
        this.realBlacklist.clear();
        for (String s : (List)this.blacklist.get()) {
            Item i = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(s));
            if (i == null || i == Items.field_190931_a) {
                EnderBags.LOGGER.error("Invalid config entry {} will be ignored from blacklist.", (Object)s);
                continue;
            }
            this.realBlacklist.add(i);
        }
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading e) {
        if (e.getConfig().getModId().equals("ender_bags")) {
            INSTANCE.parseBlacklist();
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(EnderBagConfig::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        INSTANCE = (EnderBagConfig)specPair.getLeft();
    }
}

