/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.common.network.entity;

import com.minecraftabnormals.abnormals_core.client.ClientInfo;
import com.minecraftabnormals.endergetic.common.entities.bolloom.BolloomBalloonEntity;
import com.minecraftabnormals.endergetic.core.EndergeticExpansion;
import com.minecraftabnormals.endergetic.core.interfaces.BalloonHolder;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public final class S2CUpdateBalloonsMessage {
    private int entityId;
    private int[] balloonIds;

    private S2CUpdateBalloonsMessage(int entityId, int[] balloonIds) {
        this.entityId = entityId;
        this.balloonIds = balloonIds;
    }

    public S2CUpdateBalloonsMessage(Entity entity) {
        this.entityId = entity.func_145782_y();
        List<BolloomBalloonEntity> balloons = ((BalloonHolder)entity).getBalloons();
        this.balloonIds = new int[balloons.size()];
        for (int i = 0; i < balloons.size(); ++i) {
            this.balloonIds[i] = balloons.get(i).func_145782_y();
        }
    }

    public void serialize(PacketBuffer buf) {
        buf.func_150787_b(this.entityId);
        buf.func_186875_a(this.balloonIds);
    }

    public static S2CUpdateBalloonsMessage deserialize(PacketBuffer buf) {
        return new S2CUpdateBalloonsMessage(buf.func_150792_a(), buf.func_186863_b());
    }

    public static void handle(S2CUpdateBalloonsMessage message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                World world = ClientInfo.getClientPlayerWorld();
                Entity entity = world.func_73045_a(message.entityId);
                if (entity == null) {
                    EndergeticExpansion.LOGGER.warn("Received balloons for unknown entity!");
                } else {
                    ((BalloonHolder)entity).detachBalloons();
                    for (int id : message.balloonIds) {
                        Entity balloon = world.func_73045_a(id);
                        if (!(balloon instanceof BolloomBalloonEntity)) continue;
                        ((BolloomBalloonEntity)balloon).attachToEntity(entity);
                    }
                }
            });
        }
        context.setPacketHandled(true);
    }
}

