/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.block.skull;

import com.enderio.core.common.TileEntityBase;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.BlockEio;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.block.skull.EndermanSkullRenderer;
import crazypants.enderio.base.block.skull.ItemEndermanSkull;
import crazypants.enderio.base.block.skull.SkullType;
import crazypants.enderio.base.block.skull.TileEndermanSkull;
import crazypants.enderio.base.render.IHaveRenderers;
import crazypants.enderio.base.render.IHaveTESR;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.crafting.IInfusionStabiliser;

@Optional.Interface(iface="thaumcraft.api.crafting.IInfusionStabiliser", modid="Thaumcraft")
public class BlockEndermanSkull
extends BlockEio<TileEndermanSkull>
implements IHaveTESR,
IHaveRenderers,
IInfusionStabiliser {
    @Nonnull
    public static final PropertyEnum<SkullType> VARIANT = PropertyEnum.func_177709_a((String)"variant", SkullType.class);
    @Nonnull
    public static final AxisAlignedBB AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);
    public static boolean guiRender = false;

    public static BlockEndermanSkull create(@Nonnull IModObject modObject) {
        BlockEndermanSkull res = new BlockEndermanSkull(modObject);
        res.init();
        return res;
    }

    private BlockEndermanSkull(@Nonnull IModObject modObject) {
        super(modObject, Material.field_151594_q);
        this.func_149647_a(EnderIOTab.tabEnderIOMaterials);
        this.setShape(this.mkShape(BlockFaceShape.CENTER_BIG, BlockFaceShape.UNDEFINED, BlockFaceShape.UNDEFINED));
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState state, @Nonnull IBlockAccess source, @Nonnull BlockPos pos) {
        return AABB;
    }

    @Override
    public ItemEndermanSkull createBlockItem(@Nonnull IModObject modObject) {
        return modObject.apply(new ItemEndermanSkull(this));
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_180651_a(@Nonnull IBlockState state) {
        return ((SkullType)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)SkullType.getTypeFromMeta(meta)));
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return ((SkullType)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public boolean func_149662_c(@Nonnull IBlockState bs) {
        return false;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(@Nonnull IBlockState bs) {
        return guiRender ? EnumBlockRenderType.MODEL : EnumBlockRenderType.INVISIBLE;
    }

    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer, @Nonnull EnumHand hand) {
        return this.func_176203_a(placer.func_184586_b(hand).func_77952_i());
    }

    public void onBlockPlaced(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase player, @Nonnull TileEndermanSkull te) {
        super.onBlockPlaced(world, pos, state, player, (TileEntityBase)te);
        int inc = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 16.0f / 360.0f) + 0.5)) & 0xF;
        float facingYaw = -22.5f * (float)inc;
        te.setYaw(facingYaw);
    }

    @Deprecated
    @Nonnull
    public AxisAlignedBB func_180640_a(@Nonnull IBlockState bs, @Nonnull World worldIn, @Nonnull BlockPos pos) {
        TileEndermanSkull tileEntity = (TileEndermanSkull)this.getTileEntity((IBlockAccess)worldIn, pos);
        if (tileEntity != null) {
            tileEntity.lookingAt = 20;
        }
        return super.func_180640_a(bs, worldIn, pos);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void bindTileEntitySpecialRenderer() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEndermanSkull.class, (TileEntitySpecialRenderer)new EndermanSkullRenderer());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers(final @Nonnull IModObject modObject) {
        NNList.of(SkullType.class).apply((NNList.Callback)new NNList.Callback<SkullType>(){

            public void apply(@Nonnull SkullType alloy) {
                ModelLoader.setCustomModelResourceLocation((Item)modObject.getItemNN(), (int)alloy.ordinal(), (ModelResourceLocation)new ModelResourceLocation(modObject.getRegistryName(), "variant=" + alloy.func_176610_l()));
            }
        });
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean canStabaliseInfusion(World world, BlockPos pos) {
        return true;
    }
}

