/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.capacitor;

import crazypants.enderio.api.IModObject;
import crazypants.enderio.api.capacitor.CapacitorKeyType;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.api.capacitor.Scaler;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.capacitor.CapacitorKeyRegistry;
import crazypants.enderio.base.capacitor.ScalerFactory;
import crazypants.enderio.base.init.ModObject;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="enderio")
public enum CapacitorKey implements ICapacitorKey
{
    NO_POWER((IModObject)ModObject.block_machine_base, CapacitorKeyType.ENERGY_INTAKE, "no_power"),
    LEGACY_ENERGY_INTAKE((IModObject)ModObject.block_machine_base, CapacitorKeyType.ENERGY_INTAKE, "legacy_intake"),
    LEGACY_ENERGY_BUFFER((IModObject)ModObject.block_machine_base, CapacitorKeyType.ENERGY_BUFFER, "legacy_buffer"),
    LEGACY_ENERGY_USE((IModObject)ModObject.block_machine_base, CapacitorKeyType.ENERGY_USE, "legacy_use"),
    LEGACY_ENERGY_EFFICIENCY((IModObject)ModObject.block_machine_base, CapacitorKeyType.ENERGY_EFFICIENCY, "legacy_efficiency"),
    DARK_STEEL_SWORD_ENERGY_BUFFER(ModObject.itemDarkSteelSword, CapacitorKeyType.ENERGY_BUFFER),
    DARK_STEEL_SWORD_ENERGY_INPUT(ModObject.itemDarkSteelSword, CapacitorKeyType.ENERGY_INTAKE),
    DARK_STEEL_SWORD_ENERGY_USE(ModObject.itemDarkSteelSword, CapacitorKeyType.ENERGY_USE),
    DARK_STEEL_SWORD_ABSORPTION_RATIO(ModObject.itemDarkSteelSword, CapacitorKeyType.ABSORPTION),
    DARK_STEEL_ARMOR_ENERGY_BUFFER(ModObject.itemDarkSteelChestplate, CapacitorKeyType.ENERGY_BUFFER),
    DARK_STEEL_ARMOR_ENERGY_INPUT(ModObject.itemDarkSteelChestplate, CapacitorKeyType.ENERGY_INTAKE),
    DARK_STEEL_ARMOR_ENERGY_USE(ModObject.itemDarkSteelChestplate, CapacitorKeyType.ENERGY_USE),
    DARK_STEEL_ARMOR_ABSORPTION_RATIO(ModObject.itemDarkSteelChestplate, CapacitorKeyType.ABSORPTION),
    DARK_STEEL_SHIELD_ENERGY_BUFFER(ModObject.itemDarkSteelShield, CapacitorKeyType.ENERGY_BUFFER),
    DARK_STEEL_SHIELD_ENERGY_INPUT(ModObject.itemDarkSteelShield, CapacitorKeyType.ENERGY_INTAKE),
    DARK_STEEL_SHIELD_ENERGY_USE(ModObject.itemDarkSteelShield, CapacitorKeyType.ENERGY_USE),
    DARK_STEEL_SHIELD_ABSORPTION_RATIO(ModObject.itemDarkSteelShield, CapacitorKeyType.ABSORPTION),
    DARK_STEEL_AXE_ENERGY_BUFFER(ModObject.itemDarkSteelAxe, CapacitorKeyType.ENERGY_BUFFER),
    DARK_STEEL_AXE_ENERGY_INPUT(ModObject.itemDarkSteelAxe, CapacitorKeyType.ENERGY_INTAKE),
    DARK_STEEL_AXE_ENERGY_USE(ModObject.itemDarkSteelAxe, CapacitorKeyType.ENERGY_USE),
    DARK_STEEL_AXE_ABSORPTION_RATIO(ModObject.itemDarkSteelAxe, CapacitorKeyType.ABSORPTION),
    DARK_STEEL_CROOK_ENERGY_BUFFER(ModObject.itemDarkSteelCrook, CapacitorKeyType.ENERGY_BUFFER),
    DARK_STEEL_CROOK_ENERGY_INPUT(ModObject.itemDarkSteelCrook, CapacitorKeyType.ENERGY_INTAKE),
    DARK_STEEL_CROOK_ENERGY_USE(ModObject.itemDarkSteelCrook, CapacitorKeyType.ENERGY_USE),
    DARK_STEEL_CROOK_ABSORPTION_RATIO(ModObject.itemDarkSteelCrook, CapacitorKeyType.ABSORPTION),
    DARK_STEEL_BOW_ENERGY_BUFFER(ModObject.itemDarkSteelBow, CapacitorKeyType.ENERGY_BUFFER),
    DARK_STEEL_BOW_ENERGY_INPUT(ModObject.itemDarkSteelBow, CapacitorKeyType.ENERGY_INTAKE),
    DARK_STEEL_BOW_ENERGY_USE(ModObject.itemDarkSteelBow, CapacitorKeyType.ENERGY_USE),
    DARK_STEEL_BOW_ABSORPTION_RATIO(ModObject.itemDarkSteelBow, CapacitorKeyType.ABSORPTION),
    DARK_STEEL_PICKAXE_ENERGY_BUFFER(ModObject.itemDarkSteelPickaxe, CapacitorKeyType.ENERGY_BUFFER),
    DARK_STEEL_PICKAXE_ENERGY_INPUT(ModObject.itemDarkSteelPickaxe, CapacitorKeyType.ENERGY_INTAKE),
    DARK_STEEL_PICKAXE_ENERGY_USE(ModObject.itemDarkSteelPickaxe, CapacitorKeyType.ENERGY_USE),
    DARK_STEEL_PICKAXE_ABSORPTION_RATIO(ModObject.itemDarkSteelPickaxe, CapacitorKeyType.ABSORPTION),
    DARK_STEEL_SHEARS_ENERGY_BUFFER(ModObject.itemDarkSteelShears, CapacitorKeyType.ENERGY_BUFFER),
    DARK_STEEL_SHEARS_ENERGY_INPUT(ModObject.itemDarkSteelShears, CapacitorKeyType.ENERGY_INTAKE),
    DARK_STEEL_SHEARS_ENERGY_USE(ModObject.itemDarkSteelShears, CapacitorKeyType.ENERGY_USE),
    DARK_STEEL_SHEARS_ABSORPTION_RATIO(ModObject.itemDarkSteelShears, CapacitorKeyType.ABSORPTION),
    DARK_STEEL_TREETAP_ENERGY_BUFFER(ModObject.itemDarkSteelTreetap, CapacitorKeyType.ENERGY_BUFFER),
    DARK_STEEL_TREETAP_ENERGY_INPUT(ModObject.itemDarkSteelTreetap, CapacitorKeyType.ENERGY_INTAKE),
    DARK_STEEL_TREETAP_ENERGY_USE(ModObject.itemDarkSteelTreetap, CapacitorKeyType.ENERGY_USE),
    DARK_STEEL_TREETAP_ABSORPTION_RATIO(ModObject.itemDarkSteelTreetap, CapacitorKeyType.ABSORPTION),
    DARK_STEEL_HAND_ENERGY_BUFFER(ModObject.itemDarkSteelHand, CapacitorKeyType.ENERGY_BUFFER),
    DARK_STEEL_HAND_ENERGY_INPUT(ModObject.itemDarkSteelHand, CapacitorKeyType.ENERGY_INTAKE),
    DARK_STEEL_HAND_ENERGY_USE(ModObject.itemDarkSteelHand, CapacitorKeyType.ENERGY_USE),
    DARK_STEEL_HAND_ABSORPTION_RATIO(ModObject.itemDarkSteelHand, CapacitorKeyType.ABSORPTION),
    DARK_STEEL_LEVITY_ENERGY_BUFFER(ModObject.itemStaffOfLevity, CapacitorKeyType.ENERGY_BUFFER),
    DARK_STEEL_LEVITY_ENERGY_INPUT(ModObject.itemStaffOfLevity, CapacitorKeyType.ENERGY_INTAKE),
    DARK_STEEL_LEVITY_ENERGY_USE(ModObject.itemStaffOfLevity, CapacitorKeyType.ENERGY_USE),
    DARK_STEEL_TRAVEL_ENERGY_BUFFER(ModObject.itemTravelStaff, CapacitorKeyType.ENERGY_BUFFER),
    DARK_STEEL_TRAVEL_ENERGY_INPUT(ModObject.itemTravelStaff, CapacitorKeyType.ENERGY_INTAKE),
    DARK_STEEL_TRAVEL_ENERGY_USE(ModObject.itemTravelStaff, CapacitorKeyType.ENERGY_USE),
    DARK_STEEL_CHARGER_SIMPLE_ENERGY_BUFFER(ModObject.itemInventoryChargerSimple, CapacitorKeyType.ENERGY_BUFFER),
    DARK_STEEL_CHARGER_SIMPLE_ENERGY_INPUT(ModObject.itemInventoryChargerSimple, CapacitorKeyType.ENERGY_INTAKE),
    DARK_STEEL_CHARGER_SIMPLE_ENERGY_USE(ModObject.itemInventoryChargerSimple, CapacitorKeyType.ENERGY_USE),
    DARK_STEEL_CHARGER_BASIC_ENERGY_BUFFER(ModObject.itemInventoryChargerBasic, CapacitorKeyType.ENERGY_BUFFER),
    DARK_STEEL_CHARGER_BASIC_ENERGY_INPUT(ModObject.itemInventoryChargerBasic, CapacitorKeyType.ENERGY_INTAKE),
    DARK_STEEL_CHARGER_BASIC_ENERGY_USE(ModObject.itemInventoryChargerBasic, CapacitorKeyType.ENERGY_USE),
    DARK_STEEL_CHARGER_ENERGY_BUFFER(ModObject.itemInventoryCharger, CapacitorKeyType.ENERGY_BUFFER),
    DARK_STEEL_CHARGER_ENERGY_INPUT(ModObject.itemInventoryCharger, CapacitorKeyType.ENERGY_INTAKE),
    DARK_STEEL_CHARGER_ENERGY_USE(ModObject.itemInventoryCharger, CapacitorKeyType.ENERGY_USE),
    DARK_STEEL_CHARGER_VIBRANT_ENERGY_BUFFER(ModObject.itemInventoryChargerVibrant, CapacitorKeyType.ENERGY_BUFFER),
    DARK_STEEL_CHARGER_VIBRANT_ENERGY_INPUT(ModObject.itemInventoryChargerVibrant, CapacitorKeyType.ENERGY_INTAKE),
    DARK_STEEL_CHARGER_VIBRANT_ENERGY_USE(ModObject.itemInventoryChargerVibrant, CapacitorKeyType.ENERGY_USE),
    HEAD_VANILLA_CHANCE((IModObject)ModObject.itemDarkSteelSword, CapacitorKeyType.AMOUNT, true),
    HEAD_VANILLA_CHANCE_WITHER((IModObject)ModObject.itemDarkSteelSword, CapacitorKeyType.AMOUNT, true),
    HEAD_VANILLA_CHANCE_ENDERMAN((IModObject)ModObject.itemDarkSteelSword, CapacitorKeyType.AMOUNT, true),
    HEAD_CHANCE((IModObject)ModObject.itemDarkSteelSword, CapacitorKeyType.AMOUNT, true),
    HEAD_CHANCE_WITHER((IModObject)ModObject.itemDarkSteelSword, CapacitorKeyType.AMOUNT, true),
    HEAD_CHANCE_ENDERMAN((IModObject)ModObject.itemDarkSteelSword, CapacitorKeyType.AMOUNT, true),
    HEAD_EMPOWERED_CHANCE((IModObject)ModObject.itemDarkSteelSword, CapacitorKeyType.AMOUNT, true),
    HEAD_EMPOWERED_CHANCE_WITHER((IModObject)ModObject.itemDarkSteelSword, CapacitorKeyType.AMOUNT, true),
    HEAD_EMPOWERED_CHANCE_ENDERMAN((IModObject)ModObject.itemDarkSteelSword, CapacitorKeyType.AMOUNT, true),
    HEAD_TIER_CHANCE((IModObject)ModObject.itemDarkSteelSword, CapacitorKeyType.AMOUNT, true),
    HEAD_BEHEADING_CHANCE_ENDERMAN((IModObject)ModObject.itemDarkSteelSword, CapacitorKeyType.AMOUNT, true),
    HEAD_FAKEPLAYER_CHANCE((IModObject)ModObject.itemDarkSteelSword, CapacitorKeyType.AMOUNT, true),
    HEAD_FAKEPLAYER_CHANCE_WITHER((IModObject)ModObject.itemDarkSteelSword, CapacitorKeyType.AMOUNT, true),
    HEAD_FAKEPLAYER_CHANCE_ENDERMAN((IModObject)ModObject.itemDarkSteelSword, CapacitorKeyType.AMOUNT, true);

    @Nonnull
    private final ResourceLocation registryName;
    @Nonnull
    private final IModObject owner;
    @Nonnull
    private final CapacitorKeyType valueType;
    @Nonnull
    private Scaler scaler = ScalerFactory.INVALID;
    private int baseValue = Integer.MIN_VALUE;

    private CapacitorKey(@Nonnull IModObject owner, CapacitorKeyType valueType, String shortname) {
        this.owner = owner;
        this.valueType = valueType;
        this.registryName = new ResourceLocation(owner.getRegistryName().func_110624_b(), owner.getRegistryName().func_110623_a() + "/" + shortname.toLowerCase(Locale.ENGLISH));
    }

    private CapacitorKey(IModObject owner, CapacitorKeyType valueType) {
        this(owner, valueType, valueType.name().toLowerCase(Locale.ENGLISH));
    }

    private CapacitorKey(IModObject owner, CapacitorKeyType valueType, boolean unused) {
        this.owner = owner;
        this.valueType = valueType;
        this.registryName = new ResourceLocation(owner.getRegistryName().func_110624_b(), owner.getRegistryName().func_110623_a() + "/" + this.name().toLowerCase(Locale.ENGLISH).toLowerCase(Locale.ENGLISH));
    }

    @Override
    public float getFloat(float level) {
        return (float)this.baseValue * this.scaler.scaleValue(level);
    }

    @Override
    public int getBaseValue() {
        return this.baseValue;
    }

    @Override
    @Nonnull
    public IModObject getOwner() {
        return this.owner;
    }

    @Override
    @Nonnull
    public CapacitorKeyType getValueType() {
        return this.valueType;
    }

    @Override
    @Nonnull
    public String getLegacyName() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    @Override
    public void setScaler(@Nonnull Scaler scaler) {
        this.scaler = scaler;
    }

    @Override
    public void setBaseValue(int baseValue) {
        this.baseValue = baseValue;
    }

    @Override
    public void validate() {
        if (this.scaler == ScalerFactory.INVALID || this.baseValue == Integer.MIN_VALUE) {
            throw new ICapacitorKey.UnconfiguredCapKeyException("CapacitorKey " + this.getRegistryName() + " has not been configured. This should not be possible and may be caused by a 3rd-party addon mod.");
        }
    }

    public final ICapacitorKey setRegistryName(String name) {
        throw new IllegalStateException("Attempted to set registry name with existing registry name! New: " + name + " Old: " + this.getRegistryName());
    }

    public final ICapacitorKey setRegistryName(ResourceLocation name) {
        this.setRegistryName(name.toString());
        return this;
    }

    @Override
    @Nonnull
    public final ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public final Class<ICapacitorKey> getRegistryType() {
        return ICapacitorKey.class;
    }

    @SubscribeEvent
    public static void register(RegistryEvent.Register<ICapacitorKey> event) {
        for (CapacitorKey key : CapacitorKey.values()) {
            event.getRegistry().register((IForgeRegistryEntry)key);
            Log.debug("<capacitor key=\"", key.getRegistryName() + "\" base=\"\" scaler=\"\" />");
        }
        CapacitorKeyRegistry.setValue(NO_POWER.getRegistryName(), 0, ScalerFactory.FIXED, ScalerFactory.FIXED.name());
    }
}

