/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.AbstractCrafting;
import crazypants.enderio.base.config.recipes.xml.ItemFloatAmount;
import crazypants.enderio.base.integration.tic.TicProxy;
import crazypants.enderio.base.recipe.RecipeLevel;
import crazypants.enderio.util.Prep;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class Smelting
extends AbstractCrafting {
    private float exp = Float.NaN;
    private boolean tinkers = false;
    private boolean vanilla = true;
    private Optional<ItemFloatAmount> input = this.empty();

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        try {
            super.readResolve();
            if (Float.isNaN(this.exp)) {
                if (this.valid) {
                    this.exp = FurnaceRecipes.func_77602_a().func_151398_b(this.getOutput().getItemStack());
                }
            } else {
                if (this.exp < 0.0f) {
                    throw new InvalidRecipeConfigException("Invalid negative value for 'exp'");
                }
                if (this.exp > 1.0f) {
                    throw new InvalidRecipeConfigException("Invalid value for 'exp', above 100%");
                }
            }
            if (!this.input.isPresent()) {
                throw new InvalidRecipeConfigException("Missing <input>");
            }
            if (!this.vanilla && !this.tinkers) {
                throw new InvalidRecipeConfigException("One or more of 'vanilla' or 'tinkers' must be enabled");
            }
            if (this.vanilla && this.input.get().amount != 1.0f) {
                throw new InvalidRecipeConfigException("For 'vanilla' setting an input amount is not valid");
            }
            this.valid = this.valid && this.input.get().isValid() && (!this.vanilla || Prep.isValid(this.input.get().getItemStack()));
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <smelting>");
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        super.enforceValidity();
        this.input.get().enforceValidity();
    }

    @Override
    public void register(final @Nonnull String recipeName, final @Nonnull RecipeLevel recipeLevel) {
        if (this.isValid() && this.isActive()) {
            if (this.vanilla) {
                final ItemStack result = this.getOutput().getItemStack();
                this.input.get().getThing().getItemStacks().apply((NNList.Callback)new NNList.Callback<ItemStack>(){

                    public void apply(@Nonnull ItemStack stack) {
                        ItemStack smeltingResult = FurnaceRecipes.func_77602_a().func_151395_a(stack);
                        if (Prep.isValid(smeltingResult)) {
                            if (result.func_77973_b() != smeltingResult.func_77973_b() || result.func_190916_E() != smeltingResult.func_190916_E()) {
                                Log.error("Cannot add smelting recipe " + recipeName + " (" + stack + " => " + result + ") because another mod already has registered a recipe " + stack + " => " + smeltingResult + ".");
                            } else {
                                Log.debug("Smelting recipe " + recipeName + " (" + stack + " => " + result + ") is a real duplicate and will be ignored (XP may be different).");
                            }
                        } else {
                            GameRegistry.addSmelting((ItemStack)stack, (ItemStack)result, (float)Smelting.this.exp);
                            if (recipeLevel != RecipeLevel.IGNORE) {
                                Log.warn("Ignoring recipe level " + (Object)((Object)recipeLevel) + " configured for vanilla smelting recipe '" + recipeName + "'---the vanilla furcnace doesn't have (or support) levels");
                            }
                        }
                    }
                });
            }
            if (this.tinkers) {
                TicProxy.registerSmelterySmelting(this.input.get().getThing(), this.getOutput().getThing(), 1.0f / this.input.get().amount);
            }
        }
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("exp".equals(name)) {
            this.exp = Float.parseFloat(value);
            return true;
        }
        if ("tinkers".equals(name)) {
            this.tinkers = Boolean.parseBoolean(value);
            return true;
        }
        if ("vanilla".equals(name)) {
            this.vanilla = Boolean.parseBoolean(value);
            return true;
        }
        return super.setAttribute(factory, name, value);
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("input".equals(name) && !this.input.isPresent()) {
            this.input = this.of(factory.read(new ItemFloatAmount().setAllowDelaying(false), startElement));
            return true;
        }
        return super.setElement(factory, name, startElement);
    }
}

