/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.handler;

import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.handler.KeyTracker;
import crazypants.enderio.base.lang.Lang;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="enderio", value={Side.CLIENT})
public class FovZoomHandler {
    private static double fovLevelLast = 1.0;
    private static double fovLevelNext = 1.0;
    private static long lastWorldTime = 0L;
    private static double fovLevelPreReset = 1.0;
    private static double fovLevelSaved = 1.0;

    @SubscribeEvent
    public static void onFov(EntityViewRenderEvent.FOVModifier event) {
        long worldTime = EnderIO.proxy.getTickCount();
        while (worldTime > lastWorldTime) {
            lastWorldTime = worldTime - lastWorldTime > 10L ? worldTime : ++lastWorldTime;
            fovLevelLast = fovLevelNext;
            if (KeyTracker.fovPlusFast.getBinding().func_151470_d()) {
                fovLevelNext *= 1.05;
            } else if (KeyTracker.fovMinusFast.getBinding().func_151470_d()) {
                fovLevelNext /= 1.05;
            } else if (KeyTracker.fovPlus.getBinding().func_151470_d()) {
                fovLevelNext *= 1.01;
            } else if (KeyTracker.fovMinus.getBinding().func_151470_d()) {
                fovLevelNext /= 1.01;
            }
            fovLevelNext = MathHelper.func_151237_a((double)fovLevelNext, (double)0.05, (double)1.3);
        }
        double val = fovLevelNext * event.getRenderPartialTicks() + fovLevelLast * (1.0 - event.getRenderPartialTicks());
        event.setFOV((float)((double)event.getFOV() * val));
    }

    static class FovRecallAction
    implements KeyTracker.Action {
        FovRecallAction() {
        }

        @Override
        public void execute() {
            fovLevelNext = fovLevelSaved;
        }
    }

    static class FovStoreAction
    implements KeyTracker.Action {
        FovStoreAction() {
        }

        @Override
        public void execute() {
            fovLevelSaved = fovLevelNext;
            Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)Lang.GUI_ZOOM_STORED.toChat(), true);
        }
    }

    static class FovUnresetAction
    implements KeyTracker.Action {
        FovUnresetAction() {
        }

        @Override
        public void execute() {
            fovLevelNext = fovLevelPreReset;
        }
    }

    static class FovResetAction
    implements KeyTracker.Action {
        FovResetAction() {
        }

        @Override
        public void execute() {
            fovLevelPreReset = fovLevelNext;
            fovLevelLast = (fovLevelNext = 1.0);
        }
    }
}

