/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.handler.darksteel;

import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.api.upgrades.IRule;
import crazypants.enderio.base.lang.ILang;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.util.NNPair;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public final class Rules {
    @Nonnull
    public static final IRule WEAPONS = new IRule.StaticRule(){

        @Override
        @Nonnull
        public IRule.CheckResult check(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
            return item.isWeapon() ? IRule.CheckResult.PASS : IRule.CheckResult.SILENT_FAIL;
        }
    };
    @Nonnull
    public static final IRule TOOL_BLOCK_BREAKING = new IRule.StaticRule(){

        @Override
        @Nonnull
        public IRule.CheckResult check(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
            return item.isBlockBreakingTool() ? IRule.CheckResult.PASS : IRule.CheckResult.SILENT_FAIL;
        }
    };
    @Nonnull
    public static final IRule PICKAXE = new IRule.StaticRule(){

        @Override
        @Nonnull
        public IRule.CheckResult check(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
            return item.isPickaxe() ? IRule.CheckResult.PASS : IRule.CheckResult.SILENT_FAIL;
        }
    };
    @Nonnull
    public static final IRule AXE = new IRule.StaticRule(){

        @Override
        @Nonnull
        public IRule.CheckResult check(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
            return item.isAxe() ? IRule.CheckResult.PASS : IRule.CheckResult.SILENT_FAIL;
        }
    };

    @Nonnull
    public static IRule.StaticRule callbacksFor(final @Nonnull IDarkSteelUpgrade upgrade) {
        return new IRule.StaticRule(){

            @Override
            @Nonnull
            public IRule.CheckResult check(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
                return item.hasUpgradeCallbacks(upgrade) ? IRule.CheckResult.PASS : IRule.CheckResult.SILENT_FAIL;
            }
        };
    }

    @Nonnull
    public static IRule.StaticRule forSlot(final @Nonnull EntityEquipmentSlot slot) {
        return new IRule.StaticRule(){

            @Override
            @Nonnull
            public IRule.CheckResult check(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
                return item.isForSlot(slot) ? IRule.CheckResult.PASS : IRule.CheckResult.SILENT_FAIL;
            }
        };
    }

    @Nonnull
    public static IRule.StaticRule staticCheck(final @Nonnull Function<IDarkSteelItem, Boolean> func) {
        return new IRule.StaticRule(){

            @Override
            @Nonnull
            public IRule.CheckResult check(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
                return (Boolean)func.apply(item) != false ? IRule.CheckResult.PASS : IRule.CheckResult.SILENT_FAIL;
            }
        };
    }

    @Nonnull
    public static IRule.Prerequisite withPrerequisite(@Nonnull IDarkSteelUpgrade upgrade) {
        return () -> upgrade;
    }

    @Nonnull
    public static IRule withLevels(int level, IDarkSteelUpgrade ... upgrades) {
        if (level == 0 || upgrades[level - 1] == null) {
            return Rules.not(Rules.or((IRule[])Stream.of(upgrades).filter(upgrade -> upgrade != null).map(Rules::withPrerequisite).toArray(IRule.Prerequisite[]::new)));
        }
        return Rules.withPrerequisite(upgrades[level - 1]);
    }

    @Nonnull
    public static IRule withLevels(int level, List<? extends IDarkSteelUpgrade> upgrades) {
        if (level == 0 || upgrades.get(level - 1) == null) {
            return Rules.not(Rules.or((IRule[])upgrades.stream().filter(upgrade -> upgrade != null).map(Rules::withPrerequisite).toArray(IRule.Prerequisite[]::new)));
        }
        return Rules.withPrerequisite(upgrades.get(level - 1));
    }

    @Nonnull
    public static IRule.StaticRule itemTypeTooltip(final @Nonnull ILang lang) {
        return new IRule.ItemType.Static(){

            @Override
            @Nonnull
            public IRule.CheckResult check(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
                return IRule.CheckResult.PASS;
            }

            @Override
            @Nonnull
            public ITextComponent getTooltip() {
                return lang.toChatServer();
            }
        };
    }

    @Nonnull
    public static IRule.StaticRule itemTypeTooltip(@Nonnull EntityEquipmentSlot slot) {
        switch (slot) {
            case CHEST: {
                return Rules.itemTypeTooltip(Lang.DSU_CLASS_ARMOR_CHEST);
            }
            case FEET: {
                return Rules.itemTypeTooltip(Lang.DSU_CLASS_ARMOR_FEET);
            }
            case HEAD: {
                return Rules.itemTypeTooltip(Lang.DSU_CLASS_ARMOR_HEAD);
            }
            case LEGS: {
                return Rules.itemTypeTooltip(Lang.DSU_CLASS_ARMOR_LEGS);
            }
            case MAINHAND: {
                return Rules.itemTypeTooltip(Lang.DSU_CLASS_TOOLS);
            }
        }
        return Rules.itemTypeTooltip(Lang.DSU_CLASS_EVERYTHING);
    }

    @Nonnull
    public static IRule.StaticRule or(final IRule.StaticRule ... rules) {
        return new IRule.StaticRule(){

            @Override
            @Nonnull
            public IRule.CheckResult check(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
                for (IRule.StaticRule rule : rules) {
                    if (!rule.check(stack, item).passes()) continue;
                    return IRule.CheckResult.PASS;
                }
                return IRule.CheckResult.SILENT_FAIL;
            }
        };
    }

    @Nonnull
    public static IRule or(final IRule ... rules) {
        return new IRule(){

            @Override
            @Nonnull
            public IRule.CheckResult check(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
                for (IRule rule : rules) {
                    if (!rule.check(stack, item).passes()) continue;
                    return IRule.CheckResult.PASS;
                }
                return IRule.CheckResult.SILENT_FAIL;
            }
        };
    }

    @Nonnull
    public static IRule.StaticRule not(final @Nonnull IRule.StaticRule rule) {
        return new IRule.StaticRule(){

            @Override
            @Nonnull
            public IRule.CheckResult check(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
                return rule.check(stack, item).passes() ? IRule.CheckResult.SILENT_FAIL : IRule.CheckResult.PASS;
            }
        };
    }

    @Nonnull
    public static IRule not(final @Nonnull IRule rule) {
        return new IRule(){

            @Override
            @Nonnull
            public IRule.CheckResult check(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
                return rule.check(stack, item).passes() ? IRule.CheckResult.SILENT_FAIL : IRule.CheckResult.PASS;
            }
        };
    }

    public static boolean isStatic(IRule rule) {
        return rule instanceof IRule.StaticRule;
    }

    public static Predicate<IRule> makeChecker(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
        return rule -> rule.check(stack, item).passes();
    }

    public static Predicate<IRule> makeChecker(@Nonnull NNPair<ItemStack, IDarkSteelItem> pair) {
        return rule -> rule.check((ItemStack)pair.getLeft(), (IDarkSteelItem)pair.getRight()).passes();
    }
}

