/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.handler.darksteel.gui;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.api.upgrades.IRule;
import crazypants.enderio.base.handler.darksteel.Rules;
import crazypants.enderio.base.handler.darksteel.UpgradeRegistry;
import crazypants.enderio.base.handler.darksteel.gui.ISlotSelector;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.util.NNPair;
import crazypants.enderio.util.NbtValue;
import crazypants.enderio.util.Prep;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class UpgradeCap
implements IItemHandlerModifiable {
    protected static final int INVSIZE = 9;
    protected final NNList<Holder> stacks = new NNList();
    protected final ISlotSelector ss;
    protected final EntityPlayer player;
    protected final boolean addOnly;

    public UpgradeCap(ISlotSelector ss, EntityPlayer player, boolean addOnly) {
        this.ss = ss;
        this.player = player;
        this.addOnly = addOnly;
        UpgradeRegistry.getUpgrades().stream().map(Holder::new).forEachOrdered(this::addHolder);
    }

    private void addHolder(Holder holder) {
        Holder last;
        if (!this.stacks.isEmpty() && (last = (Holder)this.stacks.get(this.stacks.size() - 1)).getKey().equals(holder.getKey())) {
            holder.isHead = false;
            last.hasNext = true;
        }
        this.stacks.add((Object)holder);
    }

    public int getSlots() {
        return this.ss.isAnvil() ? 0 : this.stacks.size() + 9;
    }

    private boolean showUpgrade(int slot) {
        Holder holder = (Holder)this.stacks.get(slot);
        return holder.upgrade.hasUpgrade(this.getOwner().getLeft()) || holder.hasNext && this.showUpgrade(slot + 1);
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (this.isInventorySlot(slot)) {
            return NbtValue.DSUINV.getStack(this.getOwner().getLeft(), slot - this.stacks.size());
        }
        return this.showUpgrade(slot) ? UpgradeRegistry.getUpgradeItem(((Holder)this.stacks.get((int)slot)).upgrade) : Prep.getEmpty();
    }

    public ItemStack getUpgradeItem(int slot) {
        if (this.isInventorySlot(slot)) {
            return new ItemStack(ModObject.itemDarkSteelUpgrade.getItemNN());
        }
        return UpgradeRegistry.getUpgradeItem(((Holder)this.stacks.get((int)slot)).upgrade);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        NNPair<ItemStack, IDarkSteelItem> owner = this.getOwner();
        if (this.isInventorySlot(slot)) {
            if (this.addOnly || Prep.isValid(NbtValue.DSUINV.getStack(owner.getLeft(), slot - this.stacks.size())) || stack.func_77973_b() != ModObject.itemDarkSteelUpgrade.getItemNN()) {
                return stack;
            }
            if (!simulate) {
                NbtValue.DSUINV.setStack(owner.getLeft(), slot - this.stacks.size(), ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                this.syncChangesToClient();
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - 1));
        }
        IDarkSteelUpgrade upgrade = ((Holder)this.stacks.get((int)slot)).upgrade;
        if (this.showUpgrade(slot) || !UpgradeRegistry.isUpgradeItem(upgrade, stack) || !upgrade.canAddToItem(owner.getLeft(), owner.getRight())) {
            return stack;
        }
        if (!simulate && !this.player.field_70170_p.field_72995_K) {
            upgrade.addToItem(owner.getLeft(), owner.getRight());
            this.syncChangesToClient();
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - 1));
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.insertItem(slot, stack, true).func_190916_E() != stack.func_190916_E();
    }

    public boolean isSlotBlocked(int slot) {
        return !this.isInventorySlot(slot) && !this.showUpgrade(slot) && !((Holder)this.stacks.get((int)slot)).upgrade.canAddToItem(this.getOwner().getLeft(), this.getOwner().getRight());
    }

    public List<ITextComponent> getSlotBlockedReason(int slot) {
        NNPair<ItemStack, IDarkSteelItem> owner = this.getOwner();
        return (List)NullHelper.first((Object[])new List[]{this.isSlotBlocked(slot) ? ((Holder)this.stacks.get((int)slot)).upgrade.getRules().stream().map(rule -> rule.check((ItemStack)owner.getLeft(), (IDarkSteelItem)owner.getRight())).filter(IRule.CheckResult::hasResult).map(IRule.CheckResult::getResult).collect(Collectors.toList()) : null, NNList.emptyList()});
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0 || this.addOnly) {
            return ItemStack.field_190927_a;
        }
        NNPair<ItemStack, IDarkSteelItem> owner = this.getOwner();
        if (this.isInventorySlot(slot)) {
            ItemStack result = NbtValue.DSUINV.getStack(owner.getLeft(), slot - this.stacks.size());
            if (!simulate) {
                NbtValue.DSUINV.setStack(owner.getLeft(), slot - this.stacks.size(), Prep.getEmpty());
                this.syncChangesToClient();
            }
            return result;
        }
        IDarkSteelUpgrade upgrade = ((Holder)this.stacks.get((int)slot)).upgrade;
        boolean existing = upgrade.hasUpgrade(owner.getLeft());
        if (!(existing && this.stacks.stream().map(holder -> holder.upgrade).filter(up -> up != upgrade && up.hasUpgrade((ItemStack)owner.getLeft())).allMatch(up -> up.canOtherBeRemoved((ItemStack)owner.getLeft(), (IDarkSteelItem)owner.getRight(), upgrade)) && owner.getRight().canUpgradeBeRemoved(owner.getLeft(), upgrade))) {
            return ItemStack.field_190927_a;
        }
        if (!simulate && !this.player.field_70170_p.field_72995_K) {
            upgrade.removeFromItem(owner.getLeft(), owner.getRight());
            this.syncChangesToClient();
        }
        return UpgradeRegistry.getUpgradeItem(upgrade);
    }

    protected void syncChangesToClient() {
        if (this.player instanceof EntityPlayerMP) {
            if (this.ss.isItem()) {
                this.player.field_71070_bA.func_75142_b();
            } else {
                ItemStack owner = this.getOwner().getLeft();
                for (int i = 0; i < this.player.field_71071_by.func_70302_i_(); ++i) {
                    if (this.player.field_71071_by.func_70301_a(i) != owner) continue;
                    ((EntityPlayerMP)this.player).field_71135_a.func_147359_a((Packet)new SPacketSetSlot(-2, i, this.player.field_71071_by.func_70301_a(i)));
                }
            }
        }
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    protected boolean isInventorySlot(int slot) {
        if (slot < 0 || slot >= this.stacks.size() + 9) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.stacks.size() + ")");
        }
        return slot >= this.stacks.size();
    }

    public boolean isStillConnectedToPlayer() {
        return this.ss.isAnvil() || this.ss.getItem(this.player).func_77973_b() instanceof IDarkSteelItem;
    }

    protected NNPair<ItemStack, IDarkSteelItem> getOwner() {
        ItemStack current = this.ss.getItem(this.player);
        if (current.func_77973_b() instanceof IDarkSteelItem) {
            return NNPair.of(current, (IDarkSteelItem)current.func_77973_b());
        }
        return NNPair.of(new ItemStack(ModObject.itemDarkSteelPickaxe.getItemNN()), (IDarkSteelItem)ModObject.itemDarkSteelPickaxe.getItemNN());
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (this.isInventorySlot(slot)) {
            if (Prep.isValid(stack) && stack.func_77973_b() != ModObject.itemDarkSteelUpgrade.getItemNN()) {
                return;
            }
            NbtValue.DSUINV.setStack(this.getOwner().getLeft(), slot - this.stacks.size(), ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
            this.syncChangesToClient();
            return;
        }
        if (Prep.isValid(stack)) {
            this.insertItem(slot, stack.func_77946_l(), false);
        } else {
            this.extractItem(slot, 1, false);
        }
    }

    public ISlotSelector getSlotSelector() {
        return this.ss;
    }

    public boolean isHead(int slot) {
        return this.isInventorySlot(slot) ? slot == this.stacks.size() : ((Holder)this.stacks.get((int)slot)).isHead;
    }

    public boolean isVisible(int slot) {
        if (!this.isStillConnectedToPlayer()) {
            return false;
        }
        if (this.isInventorySlot(slot)) {
            return true;
        }
        return ((Holder)this.stacks.get((int)slot)).upgrade.getRules().stream().filter(Rules::isStatic).allMatch(Rules.makeChecker(this.getOwner()));
    }

    public boolean isChanged() {
        return this.ss.isItem();
    }

    public boolean isAvailable() {
        if (this.ss.isAnvil()) {
            return true;
        }
        if (!this.isStillConnectedToPlayer()) {
            return false;
        }
        for (Holder holder : this.stacks) {
            if (!holder.upgrade.getRules().stream().filter(Rules::isStatic).allMatch(Rules.makeChecker(this.getOwner()))) continue;
            return true;
        }
        return false;
    }

    public boolean isLocked(int slot) {
        return this.addOnly ? this.isInventorySlot(slot) || this.showUpgrade(slot) : false;
    }

    public void dropAll(boolean wipeOriginal) {
        if (!this.player.field_70170_p.field_72995_K) {
            NNPair<ItemStack, IDarkSteelItem> owner = this.getOwner();
            for (int slot = 0; slot < this.getSlots(); ++slot) {
                ItemStack stack = this.getStackInSlot(slot);
                if (!Prep.isValid(stack)) continue;
                if (!this.isInventorySlot(slot)) {
                    if (!owner.getRight().canUpgradeBeRemoved(owner.getLeft(), ((Holder)this.stacks.get((int)slot)).upgrade)) continue;
                    this.dropSubInventory(stack, ((Holder)this.stacks.get((int)slot)).upgrade.getInventoryHandler(owner.getLeft()), wipeOriginal);
                }
                if (this.player.field_71071_by.func_70441_a(stack)) continue;
                this.player.func_71019_a(stack, true);
            }
            if (wipeOriginal) {
                owner.getLeft().func_77982_d(null);
            }
        }
    }

    private void dropSubInventory(ItemStack stack, @Nullable IItemHandler handler, boolean wipeOriginal) {
        if (handler != null) {
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                ItemStack stack1 = handler.getStackInSlot(slot);
                if (!Prep.isValid(stack)) continue;
                if (!this.player.field_71071_by.func_70441_a(stack1)) {
                    this.player.func_71019_a(stack1, true);
                }
                if (!wipeOriginal) continue;
                if (handler instanceof IItemHandlerModifiable) {
                    ((IItemHandlerModifiable)handler).setStackInSlot(slot, Prep.getEmpty());
                    continue;
                }
                handler.extractItem(slot, stack1.func_190916_E(), false);
            }
        }
    }

    private static final class Holder {
        final IDarkSteelUpgrade upgrade;
        boolean hasNext = false;
        boolean isHead = true;

        Holder(IDarkSteelUpgrade upgrade) {
            this.upgrade = upgrade;
        }

        String getKey() {
            return (String)NullHelper.first((Object[])new String[]{(String)this.upgrade.getSortKey().getKey(), ""});
        }
    }
}

