/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.init;

import com.enderio.core.EnderCore;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.diagnostics.EnderIOCrashCallable;
import crazypants.enderio.base.init.CommonProxy;
import crazypants.enderio.base.init.ModObjectRegistry;
import crazypants.enderio.base.init.TickTimer;
import crazypants.enderio.base.render.ICustomSubItems;
import crazypants.enderio.base.render.IDefaultRenderers;
import crazypants.enderio.base.render.IHaveRenderers;
import crazypants.enderio.base.render.IHaveTESR;
import crazypants.enderio.base.render.ranged.MarkerParticle;
import crazypants.enderio.util.ClientUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="enderio", value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    @Override
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @SubscribeEvent
    public static void onModelRegistryEvent(@Nonnull ModelRegistryEvent event) {
        for (IModObject mo : ModObjectRegistry.getRegistry()) {
            Block block = mo.getBlock();
            if (!(block instanceof ICustomSubItems)) {
                Item item;
                if (block instanceof IHaveRenderers) {
                    ((IHaveRenderers)block).registerRenderers(mo);
                } else if (block instanceof IDefaultRenderers) {
                    ClientUtil.registerDefaultItemRenderer(mo);
                } else if (!(block != null && block != Blocks.field_150350_a || (item = mo.getItem()) instanceof ICustomSubItems)) {
                    if (item instanceof IHaveRenderers) {
                        ((IHaveRenderers)item).registerRenderers(mo);
                    } else if (item != null && item != Items.field_190931_a) {
                        ClientUtil.registerDefaultItemRenderer(mo);
                    }
                }
            }
            if (!(block instanceof IHaveTESR)) continue;
            ((IHaveTESR)block).bindTileEntitySpecialRenderer();
        }
    }

    @Override
    public void setInstantConfusionOnPlayer(@Nonnull EntityPlayer ent, int duration) {
        ent.func_70690_d(new PotionEffect(MobEffects.field_76431_k, duration, 1, true, true));
        Minecraft.func_71410_x().field_71439_g.field_71086_bY = 1.0f;
    }

    @Override
    public long getTickCount() {
        return TickTimer.getClientTickCount();
    }

    @Override
    public void markBlock(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vector4f color) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new MarkerParticle(world, pos, color));
    }

    @Override
    protected void registerCommands() {
    }

    @Override
    public boolean isDedicatedServer() {
        return false;
    }

    @Override
    public CreativeTabs getCreativeTab(@Nonnull ItemStack stack) {
        return stack.func_77973_b().func_77640_w();
    }

    @Override
    public void stopWithErrorScreen(String ... message) {
        EnderIOCrashCallable.registerStopScreenMessage(message);
        ArrayList<String> lines = new ArrayList<String>();
        for (String string : message) {
            Log.error(string);
            if (string.length() > 71) {
                lines.addAll(ClientProxy.splitString(string, 71));
                continue;
            }
            lines.add(string);
        }
        EnderCore.proxy.throwModCompatibilityError(lines.toArray(new String[lines.size()]));
    }

    private static List<String> splitString(String msg, int lineSize) {
        ArrayList<String> res = new ArrayList<String>();
        Pattern p = Pattern.compile("\\b.{1," + (lineSize - 1) + "}\\b\\W?");
        Matcher m = p.matcher(msg);
        while (m.find()) {
            res.add(m.group());
        }
        return res;
    }

    @Override
    public boolean isGamePaused() {
        return Minecraft.func_71410_x().func_71356_B() && Minecraft.func_71410_x().func_147113_T();
    }
}

