/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.machine.recipes;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.machine.interfaces.IClearableConfiguration;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ClearConfigRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    @Nonnull
    private ItemStack lastOutput = Prep.getEmpty();

    public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nonnull World world) {
        return Prep.isValid(this.match(inv));
    }

    @Nonnull
    private ItemStack match(@Nonnull InventoryCrafting inv) {
        ItemStack input = Prep.getEmpty();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack checkStack = inv.func_70301_a(i);
            if (!Prep.isValid(checkStack)) continue;
            if (Prep.isValid(input)) {
                return Prep.getEmpty();
            }
            input = checkStack;
        }
        if (Prep.isValid(input) && input.func_77942_o()) {
            Item item = input.func_77973_b();
            if (item instanceof IClearableConfiguration) {
                return this.clear((IClearableConfiguration)item, input);
            }
            Block block = Block.func_149634_a((Item)item);
            if (block instanceof IClearableConfiguration) {
                return this.clear((IClearableConfiguration)block, input);
            }
        }
        return Prep.getEmpty();
    }

    @Nonnull
    private ItemStack clear(@Nonnull IClearableConfiguration owner, @Nonnull ItemStack stack) {
        stack = stack.func_77946_l();
        if (owner instanceof IClearableConfiguration.Handler) {
            ((IClearableConfiguration.Handler)owner).clearConfiguration(stack);
            return stack;
        }
        stack.func_77982_d(null);
        stack.func_190920_e(1);
        return stack;
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
        this.lastOutput = this.match(inv);
        return this.lastOutput;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return Prep.getEmpty();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTooltip(ItemTooltipEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player != null && (player.field_71070_bA instanceof ContainerWorkbench && ((ContainerWorkbench)player.field_71070_bA).field_75160_f.func_70301_a(0) == event.getItemStack() || player.field_71070_bA instanceof ContainerPlayer && ((ContainerPlayer)player.field_71070_bA).field_75179_f.func_70301_a(0) == event.getItemStack()) && ItemStack.func_77989_b((ItemStack)this.lastOutput, (ItemStack)event.getItemStack())) {
            event.getToolTip().add(Lang.RECIPE_CLEAR.get());
        }
        if (Log.isInDev() && event.getItemStack().func_77942_o()) {
            event.getToolTip().add("NBT: " + event.getItemStack().func_77978_p() + "(INDEV)");
        }
    }

    @Nonnull
    public NonNullList<ItemStack> func_179532_b(@Nonnull InventoryCrafting inv) {
        return NNList.func_191197_a((int)inv.func_70302_i_(), (Object)Prep.getEmpty());
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 1 && height >= 1;
    }

    public boolean func_192399_d() {
        return true;
    }
}

