/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.teleport;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.Util;
import com.enderio.core.common.vecmath.Vector3d;
import crazypants.enderio.api.teleport.TeleportEntityEvent;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.base.sound.SoundHelper;
import crazypants.enderio.base.teleport.ChunkTicket;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TeleportUtil {
    public static boolean doTeleport(@Nonnull Entity entityLiving, @Nonnull BlockPos pos, int targetDim, boolean conserveMotion, @Nonnull TravelSource source) {
        if (entityLiving instanceof FakePlayer) {
            return false;
        }
        if (entityLiving.field_70170_p.field_72995_K) {
            return TeleportUtil.checkClientTeleport(entityLiving, pos, targetDim, source);
        }
        return TeleportUtil.serverTeleport(entityLiving, pos, targetDim, conserveMotion, source);
    }

    public static boolean checkClientTeleport(@Nonnull Entity entityLiving, @Nonnull BlockPos pos, int targetDim, @Nonnull TravelSource source) {
        if (entityLiving instanceof FakePlayer) {
            return false;
        }
        return !MinecraftForge.EVENT_BUS.post((Event)new TeleportEntityEvent(entityLiving, source, pos, targetDim));
    }

    public static boolean serverTeleport(@Nonnull Entity entity, @Nonnull BlockPos pos, int targetDim, boolean conserveMotion, @Nonnull TravelSource source) {
        if (entity instanceof FakePlayer || entity.field_70128_L) {
            return false;
        }
        TeleportEntityEvent evt = new TeleportEntityEvent(entity, source, pos, targetDim);
        if (MinecraftForge.EVENT_BUS.post((Event)evt)) {
            return false;
        }
        if (entity instanceof EntityPlayerMP) {
            if (entity.field_71093_bK == targetDim) {
                TeleportUtil.serverPlayerLocalTeleport((EntityPlayerMP)entity, pos, conserveMotion, source);
            } else {
                TeleportUtil.serverPlayerDimensionTeleport((EntityPlayerMP)entity, pos, targetDim, conserveMotion, source);
            }
        } else if (entity.field_71093_bK == targetDim) {
            TeleportUtil.serverEntityLocalTeleport(entity, pos, source);
        } else {
            TeleportUtil.serverEntityDimensionTeleport(entity, pos, targetDim, source);
        }
        return true;
    }

    private static void serverEntityLocalTeleport(@Nonnull Entity entity, @Nonnull BlockPos pos, @Nonnull TravelSource source) {
        SoundHelper.playSound(entity.field_70170_p, entity, source.sound, 1.0f, 1.0f);
        entity.field_70170_p.func_175726_f(pos);
        entity.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.1, (double)pos.func_177952_p() + 0.5);
        entity.field_70143_R = 0.0f;
        SoundHelper.playSound(entity.field_70170_p, entity, source.sound, 1.0f, 1.0f);
    }

    private static void serverPlayerLocalTeleport(@Nonnull EntityPlayerMP player, @Nonnull BlockPos pos, boolean conserveMotion, @Nonnull TravelSource source) {
        ChunkTicket.loadChunk(player, player.field_70170_p, BlockCoord.get((Entity)player));
        ChunkTicket.loadChunk(player, player.field_70170_p, pos);
        SoundHelper.playSound(player.field_70170_p, (Entity)player, source.sound, 1.0f, 1.0f);
        player.field_71135_a.func_147364_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.1, (double)pos.func_177952_p() + 0.5, player.field_70177_z, player.field_70125_A);
        player.field_70143_R = 0.0f;
        SoundHelper.playSound(player.field_70170_p, (Entity)player, source.sound, 1.0f, 1.0f);
        if (conserveMotion) {
            Vector3d velocityVex = Util.getLookVecEio((EntityPlayer)player);
            SPacketEntityVelocity p = new SPacketEntityVelocity(player.func_145782_y(), velocityVex.x, velocityVex.y, velocityVex.z);
            player.field_71135_a.func_147359_a((Packet)p);
        }
    }

    private static void serverEntityDimensionTeleport(@Nonnull Entity entity, final @Nonnull BlockPos pos, int targetDim, @Nonnull TravelSource source) {
        SoundHelper.playSound(entity.field_70170_p, entity, source.sound, 1.0f, 1.0f);
        entity.changeDimension(targetDim, new ITeleporter(){

            public void placeEntity(World world, Entity entity2, float yaw) {
                entity2.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.1, (double)pos.func_177952_p() + 0.5, entity2.field_70177_z, entity2.field_70125_A);
                entity2.field_70159_w = 0.0;
                entity2.field_70181_x = 0.0;
                entity2.field_70179_y = 0.0;
                entity2.field_70143_R = 0.0f;
            }
        });
        SoundHelper.playSound(entity.field_70170_p, entity, source.sound, 1.0f, 1.0f);
    }

    private static void serverPlayerDimensionTeleport(@Nonnull EntityPlayerMP player, final @Nonnull BlockPos pos, int targetDim, boolean conserveMotion, @Nonnull TravelSource source) {
        ChunkTicket.loadChunk(player, player.field_70170_p, BlockCoord.get((Entity)player));
        SoundHelper.playSound(player.field_70170_p, (Entity)player, source.sound, 1.0f, 1.0f);
        player.field_71133_b.func_184103_al().transferPlayerToDimension(player, targetDim, new ITeleporter(){

            public void placeEntity(World world, Entity entity, float yaw) {
                entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.1, (double)pos.func_177952_p() + 0.5, entity.field_70177_z, entity.field_70125_A);
                ((EntityPlayerMP)entity).field_71135_a.func_147364_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.1, (double)pos.func_177952_p() + 0.5, entity.field_70177_z, entity.field_70125_A);
                entity.field_70159_w = 0.0;
                entity.field_70181_x = 0.0;
                entity.field_70179_y = 0.0;
                entity.field_70143_R = 0.0f;
            }
        });
        SoundHelper.playSound(player.field_70170_p, (Entity)player, source.sound, 1.0f, 1.0f);
        ChunkTicket.loadChunk(player, player.field_70170_p, BlockCoord.get((Entity)player));
        if (conserveMotion) {
            Vector3d velocityVex = Util.getLookVecEio((EntityPlayer)player);
            player.field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(player.func_145782_y(), velocityVex.x, velocityVex.y, velocityVex.z));
        }
    }
}

