/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.transceiver;

import crazypants.enderio.base.Log;
import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import crazypants.enderio.base.transceiver.Channel;
import crazypants.enderio.base.transceiver.ChannelRegister;
import crazypants.enderio.base.transceiver.IServerChannelRegister;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="enderio")
public class ServerChannelRegister
extends ChannelRegister
implements ICapabilityProvider,
IServerChannelRegister {
    @Nonnull
    public static final ServerChannelRegister instance = new ServerChannelRegister();
    @Nonnull
    private static final ResourceLocation CAP_KEY = new ResourceLocation("enderio", "channels");
    @CapabilityInject(value=IServerChannelRegister.class)
    public static Capability<IServerChannelRegister> SERVER_REGISTER = null;

    @SubscribeEvent
    public static void onWorldCaps(AttachCapabilitiesEvent<World> event) {
        if (SERVER_REGISTER != null && !((World)event.getObject()).field_72995_K) {
            event.addCapability(CAP_KEY, (ICapabilityProvider)instance);
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == SERVER_REGISTER;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == SERVER_REGISTER ? this : null);
    }

    @SubscribeEvent
    public static void preInit(EnderIOLifecycleEvent.PreInit event) {
        CapabilityManager.INSTANCE.register(IServerChannelRegister.class, (Capability.IStorage)new Capability.IStorage<IServerChannelRegister>(){

            public NBTBase writeNBT(Capability<IServerChannelRegister> capability, IServerChannelRegister instanceIn, EnumFacing side) {
                return instanceIn.serializeNBT();
            }

            public void readNBT(Capability<IServerChannelRegister> capability, IServerChannelRegister instanceIn, EnumFacing side, NBTBase nbt) {
                instanceIn.deserializeNBT(nbt);
            }
        }, (Callable)new Callable<IServerChannelRegister>(){

            @Override
            public IServerChannelRegister call() throws Exception {
                return instance;
            }
        });
    }

    public NBTBase serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        Log.debug("Saving ServerChannelRegister with gen=" + this.getGeneration());
        nbt.func_74772_a("gen", this.getGeneration());
        for (Channel channel : this.channels.values()) {
            Log.debug("ServerChannelRegister: Saving channel " + channel.getName());
            NBTTagCompound tag = new NBTTagCompound();
            channel.writeToNBT(tag);
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("list", (NBTBase)list);
        return nbt;
    }

    public void deserializeNBT(NBTBase nbtIn) {
        if (nbtIn instanceof NBTTagCompound) {
            NBTTagCompound nbt = (NBTTagCompound)nbtIn;
            long genIn = nbt.func_74763_f("gen");
            if (genIn > this.getGeneration()) {
                Log.debug("Reading ServerChannelRegister with gen=" + genIn);
                this.reset();
                this.setGeneration(genIn);
                NBTTagList list = nbt.func_150295_c("list", (int)nbt.func_74732_a());
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound tag = list.func_150305_b(i);
                    Channel channel = Channel.readFromNBT(tag);
                    if (channel != null) {
                        Log.debug("ServerChannelRegister: Reading channel " + channel.getName());
                        this.addChannel(channel);
                        continue;
                    }
                    Log.warn("ServerChannelRegister: Invalid channel NBT: " + tag);
                }
            } else {
                Log.debug("Ignoring ServerChannelRegister with gen=" + genIn);
            }
        }
    }
}

