/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.xp;

import com.enderio.core.common.network.MessageTileEntity;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.xp.ExperienceContainer;
import crazypants.enderio.base.xp.IHaveExperience;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketExperienceContainer
extends MessageTileEntity<TileEntity> {
    @Nonnull
    private ExperienceContainer xpCon;

    public PacketExperienceContainer() {
        this.xpCon = new ExperienceContainer();
    }

    public PacketExperienceContainer(@Nonnull TileEntity tile) {
        super(tile);
        IHaveExperience xpTile = (IHaveExperience)tile;
        this.xpCon = xpTile.getContainer();
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        this.xpCon.toBytes(buf);
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.xpCon.fromBytes(buf);
    }

    public static class Handler
    implements IMessageHandler<PacketExperienceContainer, IMessage> {
        public IMessage onMessage(PacketExperienceContainer message, MessageContext ctx) {
            EntityPlayer player = EnderIO.proxy.getClientPlayer();
            TileEntity tile = message.getTileEntity(player.field_70170_p);
            if (tile instanceof IHaveExperience) {
                IHaveExperience xpTile = (IHaveExperience)tile;
                xpTile.getContainer().set(message.xpCon);
            }
            return null;
        }
    }
}

