/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.xp;

import crazypants.enderio.util.MathUtil;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;

public class XpUtil {
    public static final long RATIO = 20L;
    private static final int MAX_LEVEL_INT = 21862;
    private static final int MAX_LEVEL_LONG = 0x55555566;
    private static final long LVLOFFSET32 = -XpUtil.calculateXPfromLevelHigh(32) + XpUtil.calculateXPfromLevelLow(32);

    public static int liquidToExperience(int liquid) {
        return (int)((long)liquid / 20L);
    }

    public static long liquidToExperience(long liquid) {
        return liquid / 20L;
    }

    public static int experienceToLiquid(int xp) {
        return Math.multiplyExact(xp, 20);
    }

    public static long experienceToLiquid(long xp) {
        return Math.multiplyExact(xp, 20L);
    }

    public static int getMaxLevelsStorable() {
        return 21862;
    }

    public static int getMaxLevelsStorableL() {
        return 0x55555566;
    }

    public static int getExperienceForLevel(int level) {
        if (level <= 0) {
            throw new ArithmeticException("level underflow");
        }
        return Math.toIntExact(XpUtil.calculateXPfromLevel(level));
    }

    public static long getExperienceForLevelL(int level) {
        if (level <= 0) {
            throw new ArithmeticException("level underflow");
        }
        if (level > 0x55555566) {
            return Long.MAX_VALUE;
        }
        return XpUtil.calculateXPfromLevel(level);
    }

    public static int getXpBarCapacity(int level) {
        if (level >= 30) {
            return -158 + level * 9;
        }
        if (level >= 15) {
            return -38 + level * 5;
        }
        if (level >= 0) {
            return 7 + level * 2;
        }
        throw new ArithmeticException("level underflow");
    }

    private static long calculateXPfromLevel(int level) {
        if (level >= 32) {
            return XpUtil.calculateXPfromLevelHigh(level) + LVLOFFSET32;
        }
        return XpUtil.calculateXPfromLevelLow(level);
    }

    private static long calculateXPfromLevelHigh(int level) {
        return -158L * ((long)level + 1L) + MathUtil.termial(level - 1) * 9L;
    }

    private static long calculateXPfromLevelLow(int level) {
        if (level >= 1 && level <= 16) {
            return (long)(Math.pow(level, 2.0) + (double)(6 * level));
        }
        if (level >= 17 && level <= 31) {
            return (long)(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
        }
        if (level >= 32) {
            return (long)(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
        }
        return 0L;
    }

    public static int getLevelForExperience(long experience) {
        int guess;
        for (guess = XpUtil.getLevelFromExp(experience); guess < 0x55555566 && XpUtil.calculateXPfromLevel(guess + 1) < experience; ++guess) {
        }
        while (guess > 0 && XpUtil.calculateXPfromLevel(guess) > experience) {
            --guess;
        }
        return guess;
    }

    private static int getLevelFromExp(long exp) {
        if (exp > 1395L) {
            return (int)((Math.sqrt(72L * exp - 54215L) + 325.0) / 18.0);
        }
        if (exp > 315L) {
            return (int)(Math.sqrt(40L * exp - 7839L) / 10.0 + 8.1);
        }
        if (exp > 0L) {
            return (int)(Math.sqrt(exp + 9L) - 3.0);
        }
        return 0;
    }

    public static int getPlayerXP(@Nonnull EntityPlayer player) {
        return Math.addExact(XpUtil.getExperienceForLevel(player.field_71068_ca), (int)(player.field_71106_cc * (float)player.func_71050_bK()));
    }

    public static void addPlayerXP(@Nonnull EntityPlayer player, int amount) {
        int experience;
        player.field_71067_cb = experience = Math.max(0, Math.addExact(XpUtil.getPlayerXP(player), amount));
        player.field_71068_ca = XpUtil.getLevelForExperience(experience);
        int expForLevel = XpUtil.getExperienceForLevel(player.field_71068_ca);
        player.field_71106_cc = (float)(experience - expForLevel) / (float)XpUtil.getXpBarCapacity(player.field_71068_ca);
    }
}

