/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.render;

import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.base.conduit.IConduitTexture;
import crazypants.enderio.base.render.registry.TextureRegistry;
import javax.annotation.Nonnull;

public class ConduitTexture
implements IConduitTexture {
    @Nonnull
    public static final Vector4f FULL = new Vector4f(0.0f, 0.0f, 1.0f, 1.0f);
    @Nonnull
    private static final Vector4f CORE = new Vector4f(0.125f, 0.875f, 0.875f, 0.125f);
    @Nonnull
    private static final Vector4f CORE0 = new Vector4f(0.0f, 0.5f, 0.5f, 0.0f);
    @Nonnull
    private static final Vector4f CORE1 = new Vector4f(0.5f, 0.5f, 1.0f, 0.0f);
    @Nonnull
    private static final Vector4f CORE2 = new Vector4f(0.0f, 1.0f, 0.5f, 0.5f);
    @Nonnull
    private static final Vector4f CORE3 = new Vector4f(0.5f, 1.0f, 1.0f, 0.5f);
    @Nonnull
    private final TextureRegistry.TextureSupplier texture;
    @Nonnull
    private final Vector4f uv;

    @Nonnull
    public static Vector4f core(int idx) {
        switch (idx) {
            case 0: {
                return CORE0;
            }
            case 1: {
                return CORE1;
            }
            case 2: {
                return CORE2;
            }
            case 3: {
                return CORE3;
            }
        }
        return CORE;
    }

    @Nonnull
    public static Vector4f core() {
        return ConduitTexture.core(-1);
    }

    @Nonnull
    public static Vector4f arm(int idx) {
        if (idx < 0 || idx > 3) {
            throw new RuntimeException("Invalid vOffset: " + idx);
        }
        return new Vector4f(0.0f, (float)(4 * idx) / 16.0f, 0.8125f, (float)(4 * (1 + idx)) / 16.0f);
    }

    public ConduitTexture(@Nonnull TextureRegistry.TextureSupplier texture, @Nonnull Vector4f uv) {
        this.texture = texture;
        this.uv = uv;
    }

    public ConduitTexture(@Nonnull TextureRegistry.TextureSupplier texture) {
        this(texture, FULL);
    }

    @Override
    @Nonnull
    public TextureRegistry.TextureSupplier getTexture() {
        return this.texture;
    }

    @Override
    @Nonnull
    public Vector4f getUv() {
        return this.uv;
    }
}

