/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.darksteel.upgrade.solar;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.api.upgrades.IHasPlayerRenderer;
import crazypants.enderio.api.upgrades.IRenderUpgrade;
import crazypants.enderio.api.upgrades.IRule;
import crazypants.enderio.base.handler.darksteel.AbstractUpgrade;
import crazypants.enderio.base.handler.darksteel.Rules;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgradeManager;
import crazypants.enderio.base.power.PowerHandlerUtil;
import crazypants.enderio.machines.config.config.SolarConfig;
import crazypants.enderio.machines.darksteel.upgrade.solar.SolarUpgradeLayer;
import crazypants.enderio.machines.machine.solar.SolarType;
import crazypants.enderio.machines.machine.solar.TileSolarPanel;
import info.loenwind.autoconfig.factory.IValue;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="enderiomachines")
public class SolarUpgrade
extends AbstractUpgrade
implements IHasPlayerRenderer {
    @Nonnull
    private static final String UPGRADE_NAME = "solar";
    @Nonnull
    static final String NAME = "enderio.darksteel.upgrade.solar_";
    @Nonnull
    public static final NNList<SolarUpgrade> INSTANCES = new NNList((Object[])new SolarUpgrade[]{new SolarUpgrade(SolarType.SIMPLE), new SolarUpgrade(SolarType.NORMAL), new SolarUpgrade(SolarType.ADVANCED), new SolarUpgrade(SolarType.VIBRANT)});
    @Nonnull
    private final SolarType type;

    @SubscribeEvent
    public static void registerDarkSteelUpgrades(@Nonnull RegistryEvent.Register<IDarkSteelUpgrade> event) {
        INSTANCES.apply(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
    }

    public SolarUpgrade(@Nonnull SolarType type) {
        super("enderiomachines", UPGRADE_NAME, type.ordinal(), NAME + type.ordinal(), (IValue<Integer>)((IValue)type::getUpgradeLevelCost));
        this.type = type;
    }

    @Override
    @Nonnull
    public List<IRule> getRules() {
        return new NNList((Object[])new IRule[]{Rules.forSlot(EntityEquipmentSlot.HEAD), EnergyUpgrade.HAS_ANY, Rules.withLevels(this.getLevel(), INSTANCES), Rules.itemTypeTooltip(EntityEquipmentSlot.HEAD)});
    }

    @Override
    public boolean canOtherBeRemoved(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item, @Nonnull IDarkSteelUpgrade other) {
        return !EnergyUpgradeManager.isLowestPowerUpgrade(other);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IRenderUpgrade getRender(@Nonnull AbstractClientPlayer player) {
        return SolarUpgradeLayer.withUpgrade(this);
    }

    public int getLevel() {
        return this.type.ordinal();
    }

    @Override
    public void onPlayerTick(@Nonnull ItemStack helm, @Nonnull IDarkSteelItem item, @Nonnull EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (!player.field_70170_p.func_175710_j(new BlockPos(MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)(player.field_70163_u + (double)player.eyeHeight + 0.25)), MathHelper.func_76128_c((double)player.field_70161_v)))) {
            return;
        }
        int RFperSecond = Math.round((float)this.type.getRfperSecond() * TileSolarPanel.calculateLightRatio(player.field_70170_p));
        int leftover = RFperSecond % 20;
        boolean addExtraRF = player.field_70170_p.func_82737_E() % 20L < (long)leftover;
        int toAdd = RFperSecond / 20 + (addExtraRF ? 1 : 0);
        if (toAdd != 0) {
            int nextIndex = player.getEntityData().func_74762_e("dsarmor:solar") % 4;
            for (int i = 0; i < 4 && toAdd > 0; ++i) {
                ItemStack stack = (ItemStack)player.field_71071_by.field_70460_b.get(nextIndex);
                IEnergyStorage cap = PowerHandlerUtil.getCapability((ICapabilityProvider)stack, null);
                if (cap != null && (((Boolean)SolarConfig.helmetChargeOthers.get()).booleanValue() || EnergyUpgradeManager.loadFromItem(stack) != null)) {
                    toAdd -= cap.receiveEnergy(toAdd, false);
                }
                nextIndex = (nextIndex + 1) % 4;
            }
            player.getEntityData().func_74768_a("dsarmor:solar", nextIndex);
        }
    }

    @Nonnull
    public ItemStack getRenderItem() {
        return this.type.getItemStack();
    }
}

