/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.integration.jei;

import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.integration.jei.MachinesPlugin;
import crazypants.enderio.machines.machine.crafter.ContainerCrafter;
import crazypants.enderio.machines.machine.crafter.GuiCrafter;
import crazypants.enderio.util.Prep;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public abstract class CrafterRecipeTransferHandler<E extends ContainerCrafter<?>>
implements IRecipeTransferHandler<E> {
    public static void register() {
        IRecipeTransferRegistry recipeTransferRegistry = MachinesPlugin.iModRegistry.getRecipeTransferRegistry();
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferHandler)new Simple(), "minecraft.crafting");
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferHandler)new Normal(), "minecraft.crafting");
        MachinesPlugin.iModRegistry.addRecipeClickArea(GuiCrafter.class, 198, 43, 16, 16, new String[]{"minecraft.crafting"});
        MachinesPlugin.iModRegistry.addRecipeCatalyst((Object)new ItemStack(MachineObject.block_crafter.getBlockNN()), new String[]{"minecraft.crafting"});
        MachinesPlugin.iModRegistry.addRecipeCatalyst((Object)new ItemStack(MachineObject.block_simple_crafter.getBlockNN()), new String[]{"minecraft.crafting"});
    }

    @Nullable
    public IRecipeTransferError transferRecipe(@Nonnull E crafter, @Nonnull IRecipeLayout recipeLayout, @Nonnull EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        if (!doTransfer) {
            return null;
        }
        List<GhostSlot> dummySlots = ((ContainerCrafter)((Object)crafter)).getDummySlots();
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        Map guiIngredients = itemStacks.getGuiIngredients();
        for (int i = 0; i < 9; ++i) {
            if (i >= dummySlots.size()) continue;
            if (guiIngredients.containsKey(i + 1)) {
                IGuiIngredient guiIngredient = (IGuiIngredient)guiIngredients.get(i + 1);
                List allIngredients = guiIngredient.getAllIngredients();
                if (!allIngredients.isEmpty()) {
                    dummySlots.get(i).putStack(this.findBestMatchInInventory(crafter, allIngredients), 0);
                    continue;
                }
                dummySlots.get(i).putStack(Prep.getEmpty(), 0);
                continue;
            }
            dummySlots.get(i).putStack(Prep.getEmpty(), 0);
        }
        return null;
    }

    @Nonnull
    private ItemStack findBestMatchInInventory(E crafter, List<ItemStack> allIngredients) {
        if (allIngredients.size() > 1) {
            for (Slot slot : crafter.getPlayerSlots()) {
                if (!slot.func_75216_d()) continue;
                ItemStack stack = slot.func_75211_c();
                for (ItemStack ingredient : allIngredients) {
                    if (ingredient == null || !ItemUtil.areStacksEqual((ItemStack)stack, (ItemStack)ingredient)) continue;
                    return ingredient;
                }
            }
        }
        return (ItemStack)NullHelper.first((Object[])new ItemStack[]{allIngredients.get(0), Prep.getEmpty()});
    }

    public static class Normal
    extends CrafterRecipeTransferHandler<ContainerCrafter.Normal> {
        @Nonnull
        public Class<ContainerCrafter.Normal> getContainerClass() {
            return ContainerCrafter.Normal.class;
        }
    }

    public static class Simple
    extends CrafterRecipeTransferHandler<ContainerCrafter.Simple> {
        @Nonnull
        public Class<ContainerCrafter.Simple> getContainerClass() {
            return ContainerCrafter.Simple.class;
        }
    }
}

